import QtQuick 2.5
import QtQuick.Controls 2.0
import 'ViaviStyle'


MenuItem {
    id: root
    property bool activeHighlight: false

    implicitHeight: ViaviStyle.layouts.buttonHeight
    implicitWidth: implicitHeight * 4
    height: implicitHeight
    width: implicitWidth

    background: Rectangle {
        anchors.fill: parent
        color: getBackgroundColor()
        border.color: ViaviStyle.colors.borderColor
        border.width: ViaviStyle.layouts.borderSmallWidth
        function getBackgroundColor() {
            return activeHighlight ? ViaviStyle.colors.activeColor:
                       (highlighted ? ViaviStyle.colors.menuSelectionColor : ViaviStyle.colors.contentBackgroundColor)
        }
    }

    contentItem: Text {
        text: root.text
        color: activeHighlight ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.mainInfoColor
        font: ViaviStyle.layouts.activeBoldTextFont
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }
}
