import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Window 2.2
import 'ViaviStyle'

/**
 * QtQuick 2 Menu with scroll/drag enabled and top+bottom scroll buttons.
 * Important: model and delegate need to be added to fiberModel and fiberDelegate (which will populate listView separately from the menu). This is required because of deficiencies of Menu in Qt 5.8 and earlier, which may delete elements "sent" to it through overriding. In later versions listView menu can be populated directly through overriding.
 */
Menu {
    id: menu
    height: Math.min(listView.contentHeight, platform.screenHeight)
    width: listView.contentWidth

    readonly property int indicatorHeight: ViaviStyle.layouts.imageButtonHeight * 0.8
    property alias fiberModel: listView.model
    property alias fiberDelegate: listView.delegate


    //TODO: hack - an element inserted into the menu is still needed for proper Menu sizing (ListView scrolling to work)
    onAboutToShow: {
        if ((!listView.atYBeginning) || (!listView.atYEnd)) {
            menu.insertItem(0, listView.currentItem)
        }
    }

    contentItem: ListView {
        id: listView

        MenuScrollIndicator {
            id: topScrollIndicator
            z:5
            anchors.top: parent.top
            anchors.left: parent.left
            anchors.right: parent.right
            visible: !listView.atYBeginning
            height: indicatorHeight
            isUpIndicator: true
            scrollTarget: parent
        }
        MenuScrollIndicator {
            id: bottomScrollIndicator
            z:5
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            anchors.right: parent.right
            visible: !listView.atYEnd
            height: indicatorHeight
            scrollTarget: parent
        }
    }
}
