import QtQuick 2.5
import QtQuick.Controls 2.0
import "ViaviStyle"

Rectangle{
    id: root

    property bool isSelected
    property alias text: textId.text
    signal clicked()

    height: ViaviStyle.layouts.buttonHeight

    anchors.left: parent.left
    anchors.right: parent.right

    color: isSelected ? ViaviStyle.colors.activeColor: ViaviStyle.colors.contentBackgroundColor

    Text {
        id: textId

        anchors.centerIn: parent
        font: ViaviStyle.layouts.activeBoldTextFont
        color: isSelected ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.mainInfoColor
    }

    MouseArea {
        anchors.fill: parent
        onClicked: {
            root.clicked()
        }
    }
}
