import QtQuick 2.3
import QtQuick.Layouts 1.1
import "ViaviStyle"

Item{
    height: ViaviStyle.layouts.buttonHeight

    Row{
        id: buttonsRow
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layouts.mediumMargin

        spacing: ViaviStyle.layouts.mediumMargin
        
        FiberImageButton{
        	visible: fcomp_res_isSwitchSelected.value
        	
            source: ViaviStyle.images.indicatorLeft
            onClicked:{
                fcomp_act_decreaseMpoReferenceAction.invoke()
            }
        }
        
        Text {
        	visible: fcomp_res_isSwitchSelected.value
            text: "#"+fcomp_res_referenceChannelSelected.value
            font: ViaviStyle.layouts.tableTitleFont
            color: ViaviStyle.colors.mainInfoColor
            
            width: 20
            horizontalAlignment: Text.AlignHCenter
            
            anchors.verticalCenter: parent.verticalCenter
        }
        
        FiberImageButton{
        	visible: fcomp_res_isSwitchSelected.value
        	
            source: ViaviStyle.images.indicatorRight
            onClicked:{
                fcomp_act_increaseMpoReferenceAction.invoke()
            }
        }

        FiberImageButton{
        	visible: true
            source: ViaviStyle.images.factoryResetIcon
            onClicked:{
                fcomp_act_factoryReferenceAction.invoke()
            }
        }

        Item{
            width: ViaviStyle.layouts.buttonHeight / 3
            anchors.top: parent.top
            anchors.bottom: parent.bottom
        }
    }
}
