import QtQuick 2.3
import QtQuick.Layouts 1.2
import "ViaviStyle"

RowLayout {
    id : root

    spacing : ViaviStyle.layouts.mediumMargin

    EventNameAndStatus {
        id: eventStatus

        Layout.preferredWidth: parent.width * 0.3

        Layout.fillHeight: true

        event_alarm: events_res_alarm.value
        event_name: events_res_eventName.value
        event_problemEvent: events_res_eventProblem.value
        event_threshold1: events_res_threshold1.value
        event_threshold2: events_res_threshold2.value
        event_diagnosisCause: events_res_diagnosisCause.value
    }

    EventDetails {
        visible: eventStatus.detailsVisible

        Layout.fillWidth: true
        Layout.fillHeight: true

        event_problemEvent: events_res_eventProblem.value
        event_threshold1: events_res_threshold1.value
        event_threshold2: events_res_threshold2.value
        event_diagnosisCause: events_res_diagnosisCause.value
    }

    EventDataTable {
        visible: !eventStatus.detailsVisible

        Layout.fillWidth: true
        Layout.fillHeight: true
    }
}

