import QtQuick 2.3
import QtQuick.Layouts 1.2
import "ViaviStyle"

FiberContainer {
    id: root

    property int fullTableHeight: 2 * ViaviStyle.layouts.mediumMargin
                    + ViaviStyle.layouts.mediumMargin + ViaviStyle.layouts.separatorSize + ViaviStyle.layouts.headerFontMetrics.height
                    + theListView.count * (ViaviStyle.layouts.tableFontMetrics.height + 2 * (ViaviStyle.layouts.mediumMargin + ViaviStyle.layouts.separatorSize))

    function getTableText(value){
        if(value === ""){
            return "--"
        }
        return value
    }

    function getTextColor(alarm, text){
        if(text === ""){
            return ViaviStyle.colors.mainInfoColor
        }else{
            return ViaviStyle.colors.getTextColor(alarm)
        }
    }

    ColumnLayout {
        id: columnId
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.leftMargin : ViaviStyle.layouts.largeMargin
        anchors.rightMargin : ViaviStyle.layouts.largeMargin
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.topMargin : ViaviStyle.layouts.mediumMargin
        anchors.bottomMargin : ViaviStyle.layouts.mediumMargin

        property int cellWidth : width / events_res_nbColumns.value

        TableHeaderRow{
            TableHeaderCell{
                width: columnId.cellWidth
                valueText: events_res_detailColumn0Label.value
                valueTextHorizontalAllignment: Text.AlignHCenter
            }
            TableHeaderCell{
                width: columnId.cellWidth
                valueText: events_res_detailColumn1Label.value
                valueTextHorizontalAllignment: Text.AlignHCenter
            }
            TableHeaderCell{
                width: columnId.cellWidth
                valueText: events_res_detailColumn2Label.value
                valueTextHorizontalAllignment: Text.AlignHCenter
            }
            TableHeaderCell{
                width: columnId.cellWidth
                valueText: events_res_detailColumn3Label.value
                valueTextHorizontalAllignment: Text.AlignHCenter
                visible: events_res_bIsColumn3Visible.value
            }
        }

        ListView {
            id: theListView

            Layout.fillHeight : true
            Layout.fillWidth: true

            boundsBehavior: Flickable.OvershootBounds
            clip: true
            model: events_res_slmEventDetails.value

            delegate: TableRow {
                TableTextCell{
                    width: columnId.cellWidth
                    valueText: model.detailColumn0
                    valueTextHorizontalAllignment: Text.AlignHCenter
                }
                TableTextCell{
                    width: columnId.cellWidth
                    valueText: root.getTableText(model.detailColumn1)
                    valueTextHorizontalAllignment: Text.AlignHCenter
                }
                TableTextCell{
                    width: columnId.cellWidth
                    valueText: root.getTableText(model.detailColumn2)
                    valueColor: root.getTextColor(model.detailAlarmColumn2, model.detailColumn2)
                    valueTextHorizontalAllignment: Text.AlignHCenter
                }
                TableTextCell{
                    width: columnId.cellWidth
                    valueText: root.getTableText(model.detailColumn3)
                    valueColor: root.getTextColor(model.detailAlarmColumn3, model.detailColumn3)
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    visible: events_res_bIsColumn3Visible.value
                }
            }
        }
    }
}

