import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import "ViaviStyle"

Popup
{
    id: root

    width: parent.width
    height: parent.height

    background: Rectangle{

        anchors.fill: parent

        color: ViaviStyle.colors.transparentBackgroundColor

        MouseArea{
            anchors.fill: parent

            onClicked: {

            }
        }
    }

    FiberContainer{
        anchors.fill: parent
        anchors.margins: 2 * ViaviStyle.layouts.largeMargin

        ColumnLayout{
            id: mainArea
            anchors.fill: parent
            anchors.margins: ViaviStyle.layouts.mediumMargin

            Item {

                Layout.fillWidth: true

                height: ViaviStyle.layouts.buttonHeight


                FiberImageButton{
                    id: button

                    anchors.right: parent.right

                    source: ViaviStyle.images.closeButtonIcon

                    onClicked:{
                        dwdmGrid_act_closeGrid.invoke()
                    }
                }
            }

            Item {
               Layout.fillWidth: true

                height: ViaviStyle.layouts.buttonHeight

                FiberImageButton{

                    anchors.left: parent.left

                    source: ViaviStyle.images.addIcon

                    onClicked:{
                        dwdmGrid_act_addSelected.invoke()
                    }
                }

                FiberButton{
                    width: ViaviStyle.layouts.buttonHeight * 5
                    height: ViaviStyle.layouts.buttonHeight

                    anchors.right: deselectAll.left
                    anchors.rightMargin: ViaviStyle.layouts.mediumMargin

                    text: dwdmGrid_res_selectAllButtonText.value

                    onClicked:{
                        dwdmGrid_act_selectAll.invoke()
                    }
                }

                FiberButton{
                    id: deselectAll

                    width: ViaviStyle.layouts.buttonHeight * 5
                    height: ViaviStyle.layouts.buttonHeight

                    anchors.right: parent.right

                    text: dwdmGrid_res_deselectAllButtonText.value

                    onClicked:{
                       dwdmGrid_act_deselectAll.invoke()
                    }
                }
            }

            property int nrOfColumns: 5
            property real cellWidth: width / nrOfColumns

            TableHeaderRow{
                TableHeaderCell{
                    width: mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: dwdmGrid_res_channelNumberHeader.value
                }
                TableHeaderCell{
                    width:  mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: dwdmGrid_res_channelLabelHeader.value
                }
                TableHeaderCell{
                    width:  mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: dwdmGrid_res_frequencyHeader.value
                }
                TableHeaderCell{
                    width:  mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: dwdmGrid_res_lambdaHeader.value
                }
                TableHeaderCell{
                    id: selectedHeaderCell
                    width:  mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: dwdmGrid_res_selectedHeader.value

                    canFilter: true

                    onFilterChanged: dwdmGrid_cfg_filterSelected.value = filter

                    Component.onCompleted: {
                        filter = dwdmGrid_cfg_filterSelected.value
                    }
                }
            }

            ListView {
                id: list
                Layout.fillWidth: true
                Layout.fillHeight: true

                boundsBehavior: Flickable.OvershootBounds
                clip: true
                model: dwdmGrid_res_gridTable.value



                delegate: TableRow {
                    TableTextCell{
                        id: indexCell
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: channelNumber
                    }

                    TableTextCell{
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: channelLabel
                    }

                    TableTextCell{
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: frequency
                    }

                    TableTextCell{
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: lambda
                    }

                    TableTextCell{
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: selected
                                    ? dwdmGrid_res_channelSelectedLabel.value
                                    : dwdmGrid_res_channelUnselectedLabel.value

                        //verify the index against valueCount to trigger an update on valueCountChange
                        //setting an elfarray will emit a valueChanged and valueCountChanged even if the data hasn't actually changed.
                        //this will update the cell item when the vector is changed
                        property bool selected: model.index < dwdmGrid_res_channelsSelection_int32ARRAY.valueCount
                                                ? (dwdmGrid_res_channelsSelection_int32ARRAY.at(model.index) !== 0)
                                                : false


                    }

                    onClicked: {
                        dwdmGrid_act_toggleChannel.invokeWithStringArg(channelIndex)
                    }
                }
            }
        }
    }
}
