import QtQuick 2.3
import QtQuick.Controls 2.0
import elf_plugin 1.0

import "ViaviStyle"

Item {
    id: rootId

    readonly property real numberOfVisibleCurves: 4
    readonly property real cursorInfoLineMaxSize: 56

    height: ViaviStyle.layouts.imageButtonHeight

    property Item trace

    FiberPopup {
        id:     tabPopupId

        FiberToolButton {
            visible: misc_res_traceLockVisible.value
            text: misc_res_traceLockLabel.value
            elfAction: misc_act_traceLock
        }

        FiberToolButton {
            visible: misc_res_allTraceLockVisible.value
            text: misc_res_allTraceLockLabel.value
            elfAction: misc_act_allTraceLock
        }

        FiberToolButton {
            visible: misc_res_removeTraceVisible.value
            text: misc_res_removeTraceLabel.value
            elfAction: misc_act_removeTrace
        }

        FiberToolButton {
            visible: misc_res_removeAllTraceVisible.value
            text: misc_res_removeAllTraceLabel.value
            elfAction: misc_act_removeAllTrace
        }
        
        FiberToolButton {
            id: hideTraceId
            visible: listViewId.count > 1 && !misc_res_hideAllTraceVisible.value
            text: misc_res_hideAllTraceLabel.value
            elfAction: misc_act_hideAllTrace
        }
        
        FiberToolButton {
            id: showTraceId
            visible: listViewId.count > 1 && !hideTraceId.visible
            text: misc_res_showAllTraceLabel.value
            elfAction: misc_act_showAllTrace
        }
    }

    property FiberPopup tabPopup : (misc_res_traceLockVisible.value || misc_res_allTraceLockVisible.value
                                    || misc_res_removeTraceVisible.value || misc_res_removeAllTraceVisible.value || listViewId.count > 1)
                                   ? tabPopupId : null

    Rectangle {
        id: laserSwitchBar
        width: parent.width
        height: parent.height
        color: ViaviStyle.colors.borderColor

        Image {
            id: leftIndicator

            visible: !listViewId.atXBeginning

            width: ViaviStyle.layouts.largeMargin
            height: ViaviStyle.layouts.largeMargin

            anchors.left: parent.left
            anchors.leftMargin: ViaviStyle.layouts.mediumMargin
            anchors.verticalCenter: parent.verticalCenter

            source: ViaviStyle.images.indicatorLeft
            fillMode: Image.PreserveAspectFit
        }


        Image {
            id: rightIndicator

            visible: !listViewId.atXEnd

            width: ViaviStyle.layouts.largeMargin
            height: ViaviStyle.layouts.largeMargin

            anchors.right: rightContainer.left
            anchors.rightMargin: ViaviStyle.layouts.veryLargeMargin
            anchors.verticalCenter: parent.verticalCenter

            source: ViaviStyle.images.indicatorRight
            fillMode: Image.PreserveAspectFit
        }

        //trace_cfg_selectedIndex gets updated before trace_res_curveSelector_stringARRAY
        //so binding doesn't work and should update both at the same time
        //might be able to return binding if trace_res_curveSelector_stringARRAY is fixed and updated before the currentIndex
        function updateCurrentIndex()
        {
            if(listViewId.count > trace_cfg_selectedIndex.value){
                listViewId.currentIndex = trace_cfg_selectedIndex.value
            }
            else {
                listViewId.currentIndex = -1
            }
        }

        Connections{
            target: listViewId
            function onCountChanged() {
            	laserSwitchBar.updateCurrentIndex()
            }

        }

        Connections{
            target: trace_cfg_selectedIndex
            function onValueChanged() {
            	laserSwitchBar.updateCurrentIndex()
            }
        }

        ListView {
            id: listViewId
            property bool isPmdScreen: status_res_osaMode.value === status_res_osaMode.enums.ecFunction_Pmd
            visible: (isPmdScreen && multigraphsStates_res_isPmdFftActive.value) ? false : true
            anchors.left: leftIndicator.right
            anchors.right: rightIndicator.left

            height: laserSwitchBar.height
            model: trace_res_curveSelector.value


            flickableDirection: Flickable.HorizontalFlick
            clip: true

            orientation: ListView.Horizontal
            snapMode: ListView.SnapToItem
            boundsBehavior: Flickable.StopAtBounds

            delegate: CheckTextButton {
                id: delegate
                height: listViewId.height
                width: listViewId.width / rootId.numberOfVisibleCurves
                centerContent: true
                uncheckedColor:  ViaviStyle.colors.traceColors[model.traceIndex]
                checked: trace_cfg_selectedIndex.value === model.traceIndex

                mouseArea.longPressMenu: rootId.tabPopup


                text: (model.isReference ? "[" : "") + model.traceLabel + (model.isReference ? "]" : "")

                FiberColorImage{
                    anchors.left: delegate.textElement.right
                    anchors.bottom: delegate.textElement.bottom

                    color: delegate.checked ? ViaviStyle.colors.selectedColor : delegate.uncheckedColor
                    source: ViaviStyle.images.smallRefIcon

                    visible: model.isReference
                }

                mouseArea.onClicked: {
                    trace_cfg_selectedIndex.value = model.traceIndex;
                }

                mouseArea.onBeforePressAndHold: {
                    trace_cfg_selectedIndex.value = model.traceIndex;
                }
            }
        }

        Item{
            id: rightContainer

            visible: status_res_cursorsEnabled.value
            width: Math.max ( ViaviStyle.layouts.cursorInfoFontMetrics.averageCharacterWidth * cursorInfoLineMaxSize, parent.width / 2)
                   + lockArea.width
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.right: parent.right

            Item{
                visible: !additionalCursors

                anchors.fill: parent
                anchors.margins: ViaviStyle.layouts.smallMargin * 2

                FiberImageButton {
                    id: lockButton

                    height: parent.height
                    width: height
                    anchors.left: parent.left
                    
                    checked: trace_res_cursorsLocked.value

                    source: checked ? ViaviStyle.images.cursorsLockedBtnImg : ViaviStyle.images.cursorsUnlockedBtnImg

                    onClicked: {
                        trace_act_lockCursorsPosition.invoke()
                    }
                }

                CursorsLockArea {
                    id: lockArea

                    anchors.left: lockButton.right

                    topCursor: trace.cursorDragA
                    bottomCursor: trace.cursorDragB

                    mouseAreaWidth: Math.max(cursorAInfoText.contentWidth, cursorBInfoText.contentWidth) + width

                    onSgnToggle: {
                        trace_act_toggleCursorsLock.invoke()
                    }
                }

                Item {
                    id: cursorInfoBar
                    anchors.left: lockArea.right
                    anchors.right: parent.right
                    height: parent.height

                    CursorInfoLable {
                        id: cursorAInfoText

                        anchors.left: parent.left
                        anchors.right: parent.horizontalCenter
                        anchors.top: parent.top
                        anchors.bottom: parent.verticalCenter

                        cursor: trace.cursorDragA
                    }

                    CursorInfoLable {
                        id: cursorBInfoText

                        anchors.left: parent.left
                        anchors.right: parent.horizontalCenter
                        anchors.top: parent.verticalCenter
                        anchors.bottom: parent.bottom

                        cursor: trace.cursorDragB
                    }

                    function getXDiff(){
                        return trace.cursorDragA.displayedXValue
                                - trace.cursorDragB.displayedXValue
                    }

                    function getYDiff(){
                        return trace.cursorDragA.displayedYValue
                                - trace.cursorDragB.displayedYValue
                    }

                    Text {
                        id: cursorsABdistance

                        anchors.left: parent.horizontalCenter
                        //in case the cursorA cursorB info is smaller than half of the parent, allow this item to extend beyond hCenter of parent
                        //cursorsABYDiff has a fixed font and is alligned to the right. this item is aligned to it
                        anchors.leftMargin: - Math.max(0,
                                                       Math.min(cursorAInfoText.width - cursorAInfoText.contentWidth,
                                                                cursorBInfoText.width - cursorBInfoText.contentWidth)
                                                       )
                        anchors.right: cursorsABYDiff.left
                        anchors.rightMargin: ViaviStyle.layouts.mediumMargin
                        anchors.top: parent.top
                        anchors.bottom: parent.verticalCenter
                        horizontalAlignment: Text.AlignRight

                        minimumPixelSize : ViaviStyle.layouts.smallFontSize / 2
                        fontSizeMode: Text.HorizontalFit
                        font: ViaviStyle.layouts.cursorInfoFont

                        text: "A-B: " +
                              Math.round(Math.abs(trace_res_cursorABDistance.value)* 100) / 100 + " " + trace_res_unitDisplayedX.value

                        color: ViaviStyle.colors.mainInfoColor
                        verticalAlignment: Text.AlignVCenter

                    }

                    Text {
                        id: cursorsABYDiff

                        anchors.right: parent.right
                        anchors.top: parent.top
                        anchors.bottom: parent.verticalCenter
                        width: contentWidth

                        font: ViaviStyle.layouts.cursorImportantFont

                        text: Math.round(Math.abs(cursorInfoBar.getYDiff())* 1000) / 1000 + " " + trace_res_unitDisplayedY.value
                        color: ViaviStyle.colors.mainInfoColor
                        verticalAlignment: Text.AlignVCenter
                        horizontalAlignment: Text.AlignRight
                    }

                    Text {
                        id: cursorsABsectionAttenuation

                        anchors.left: cursorsABdistance.left
                        //this will align the actual text to the text of cursorsABdistance (which is right aligned)
                        anchors.leftMargin: cursorsABdistance.width - cursorsABdistance.contentWidth
                        anchors.right: parent.right
                        anchors.top: parent.verticalCenter
                        anchors.bottom: parent.bottom

                        visible: trace_res_conversionUnit.value

                        minimumPixelSize: ViaviStyle.layouts.smallFontSize / 2
                        fontSizeMode: Text.Fit
                        font: ViaviStyle.layouts.cursorInfoFont

                        property double attenuationValue: Math.round((Math.abs(cursorInfoBar.getYDiff()) /
                                                                      (Math.abs(cursorInfoBar.getXDiff()) * trace_res_conversionUnit.value)) * 1000) / 1000
                        text:  isNaN(attenuationValue) ? ""
                                                       : attenuationValue + " " + trace_res_unitDisplayedY.value + "/km"
                        color: ViaviStyle.colors.mainInfoColor
                        verticalAlignment: Text.AlignVCenter
                    }
                }
            }

            Item{
                visible: additionalCursors

                anchors.fill: parent

                Item{
                    id: aCursorsContainer

                    anchors.left: parent.left
                    anchors.right: parent.horizontalCenter
                    anchors.top: parent.top
                    anchors.bottom: parent.bottom

                    anchors.margins: ViaviStyle.layouts.smallMargin * 2

                    FiberImageButton {
                        id: aLockButton

                        height: parent.height
                        width: height
                        anchors.left: parent.left

                        checked: trace_res_cursorsLocked.value

                        source: checked ? ViaviStyle.images.cursorsLockedBtnImg : ViaviStyle.images.cursorsUnlockedBtnImg
                        
                        onClicked: {
                            trace_act_lockCursorsPosition.invoke()
                        }
                    }

                    CursorsLockArea{
                        id: aLockArea

                        anchors.left: aLockButton.right

                        topCursor: trace.cursorDragA
                        bottomCursor: trace.cursorDragAdditionalA

                        mouseAreaWidth: Math.max(aCursorAInfoText.contentWidth, aCursorBInfoText.contentWidth) + width

                        onSgnToggle: {
                            if ((trace.lastUsedCursor !== trace.cursorDragA) && (trace.lastUsedCursor !== trace.cursorDragAdditionalA)) {
                                trace.lastUsedCursor = topCursor
                            }
                            else {
                                if (trace.lastUsedCursor === topCursor && !trace.additionalCursorALock) {
                                    trace.lastUsedCursor = bottomCursor
                                }
                                else if (trace.lastUsedCursor === bottomCursor && !trace.additionalCursorALock) {
                                    trace.lastUsedCursor = topCursor
                                    trace.additionalCursorALock = true
                                }
                                else {
                                    trace.lastUsedCursor = topCursor
                                    trace.additionalCursorALock = false
                                }
                            }

                            trace.updateCurrentCursors()
                        }

                        onVisibleChanged: {
                            if(visible){
                                if (trace.lastUsedCursor.connectedCursor) {
                                    trace.lastUsedCursor = topCursor
                                }
                                trace.additionalCursorALock = false
                            }

                            trace.updateCurrentCursors()
                        }
                    }

                    CursorInfoLable {
                        id: aCursorAInfoText

                        anchors.left: aLockArea.right
                        anchors.right: parent.right
                        anchors.top: parent.top
                        anchors.bottom: parent.verticalCenter

                        cursor: trace.cursorDragA
                    }

                    CursorInfoLable {
                        id: aCursorBInfoText

                        anchors.left: aLockArea.right
                        anchors.right: parent.right
                        anchors.top: parent.verticalCenter
                        anchors.bottom: parent.bottom

                        cursor: trace.cursorDragAdditionalA
                    }
                }

                Item{

                    anchors.left: aCursorsContainer.right
                    anchors.right: parent.horizontalCenter
                    anchors.top: parent.top
                    anchors.bottom: parent.bottom

                    anchors.margins: ViaviStyle.layouts.smallMargin * 2

                    CursorsLockArea{
                        id: bLockArea

                        anchors.left: parent.left

                        topCursor: trace.cursorDragB
                        bottomCursor: trace.cursorDragAdditionalB

                        mouseAreaWidth: Math.max(bCursorAInfoText.contentWidth, bCursorBInfoText.contentWidth) + width

                        onVisibleChanged: {
                            if(visible) {
                                trace.additionalCursorBLock = false
                            }
                        }

                        onSgnToggle: {
                            if ((trace.lastUsedCursor !== trace.cursorDragB) && (trace.lastUsedCursor !== trace.cursorDragAdditionalB)) {
                                trace.lastUsedCursor = topCursor
                            }
                            else {
                                if (trace.lastUsedCursor === topCursor && !trace.additionalCursorBLock) {
                                    trace.lastUsedCursor = bottomCursor
                                }
                                else if (trace.lastUsedCursor === bottomCursor && !trace.additionalCursorBLock) {
                                    trace.lastUsedCursor = topCursor
                                    trace.additionalCursorBLock = true
                                }
                                else {
                                    trace.lastUsedCursor = topCursor
                                    trace.additionalCursorBLock = false
                                }
                            }

                            trace.updateCurrentCursors()
                        }
                    }

                    CursorInfoLable {
                        id: bCursorAInfoText

                        anchors.left: bLockArea.right
                        anchors.right: parent.right
                        anchors.top: parent.top
                        anchors.bottom: parent.verticalCenter

                        cursor: trace.cursorDragB
                    }

                    CursorInfoLable {
                        id: bCursorBInfoText

                        anchors.left: bLockArea.right
                        anchors.right: parent.right
                        anchors.top: parent.verticalCenter
                        anchors.bottom: parent.bottom

                        cursor: trace.cursorDragAdditionalB
                    }
                }
            }
        }
    }
}
