import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2

import "ViaviStyle"

//TODO: this can be unified with FixMessagePopup too!
Popup {
    id: fiberPopup

    property string titleString: ''
    default property alias content: contentData.data
    property int borderSize: ViaviStyle.layouts.mediumMargin
    property color backgroundColor: ViaviStyle.colors.popupBackgroundColor

    //TODO: This is a workaround getting the same functionality of Overlay.overlay from Qt 5.10. Replace when upgrading Qt
    property Item overlayReplacer: null

    margins: 0
    padding: ViaviStyle.layouts.smallMargin

    background: Rectangle {
        anchors.fill: parent
        color: backgroundColor
    }

    ColumnLayout {
        id: mainArea
        anchors.fill: parent

        Layout.fillHeight: true
        Layout.fillWidth: true

        Item {
            id: headerAndCloseButton
            Layout.fillWidth: true
            height: ViaviStyle.layouts.buttonHeight
            anchors.margins: borderSize

            Text {
                id: headerText
                font: ViaviStyle.layouts.titleTextFont
                text: titleString
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                anchors.centerIn: parent
                color: ViaviStyle.colors.mainInfoColor
            }

            FiberImageButton {
                id: closeButton
                anchors.right: parent.right
                source: ViaviStyle.images.closeButtonIcon
                onClicked: {
                    fiberPopup.close()
                }
            }
        }
        Column {
            id: contentData

            spacing: ViaviStyle.layouts.smallMargin
        }
    }
}

