import QtQuick 2.5
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import "ViaviStyle"

Item{
    id: root
    property alias text: textId.text
    signal clicked

    MouseArea{
        id: textMouseArea
        anchors.fill: parent

        onClicked: root.clicked()
    }

    Row{
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.top: parent.top
        width: parent.height / 2
        spacing: ViaviStyle.layouts.mediumMargin

        FiberColorImage{
            anchors.verticalCenter: parent.verticalCenter

            height: parent.height - 2 * ViaviStyle.layouts.largeMargin

            width: height
            color: textMouseArea.pressed ? ViaviStyle.colors.selectedColor : ViaviStyle.colors.activeColor
            source: ViaviStyle.images.iconSettings
        }

        Text{
            id: textId

            anchors.top: parent.top
            anchors.bottom: parent.bottom

            width: contentWidth

            font: ViaviStyle.layouts.veryLargeBoldFont
            verticalAlignment: Text.AlignVCenter

            color: textMouseArea.pressed ? ViaviStyle.colors.selectedColor : ViaviStyle.colors.activeColor
        }
    }
}

