import QtQuick 2.5
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0
import elf_plugin 1.0

import "ViaviStyle"

RowLayout{
    id: root

    property bool clickableText: false
    property string text: ""
    property alias textWidth:  textContainer.width

    default property alias activeItemDate: activeItemContainer.data

    signal textClicked()

    anchors.left: parent.left
    anchors.right: parent.right
    height: ViaviStyle.layouts.buttonHeight + 2 * ViaviStyle.layouts.mediumMargin

    spacing: ViaviStyle.layouts.mediumMargin

    Item{
        id: textContainer
        Layout.preferredWidth: parent.width * 0.25
        Layout.fillHeight: true



        Loader{
            anchors.fill: parent

            active: !root.clickableText
            sourceComponent: ConfigLineText{
                id: simpleText

                text: root.text
            }
        }

        Loader{
            anchors.fill: parent

            active: root.clickableText

            sourceComponent: ConfigLineClickableText{
                text: root.text
                onClicked: root.textClicked()
            }
        }
    }

    Item{
        id: activeItemContainer

        Layout.fillWidth: true
        Layout.fillHeight: true
    }
}
