import QtQuick 2.7
import QtQuick.Controls 2.0

CheckBox {
    id:c1
    width: parent.height
    spacing: 3
    leftPadding: 3

    indicator: Rectangle {
        implicitWidth: parent.height
        implicitHeight: parent.height
        height: implicitHeight
        width: implicitWidth
        x: c1.leftPadding
        y: parent.height / 2 - height / 2
        radius: 3
        border.color:"black"
        Image {
            fillMode: Image.PreserveAspectFit
            width: parent.height /2
            height: parent.height /2
            x: parent.height / 4
            y: parent.height / 4
            source: "/acterna/storage/look-and-feel/generic/checkmark.png"
            visible: c1.checked
        }
    }
    contentItem: Text {
        text: c1.text
        font: c1.font
        color: "white"
        verticalAlignment: Text.AlignVCenter
        leftPadding: c1.indicator.width + c1.spacing
    }
}
