import QtQuick 2.3
import "Viavi_Colors.js" as VColor

Item {
    id: bg
    property int pourcentage : 0
    property bool landscape: false
    property string goodcolor: VColor.cViaviColorGreen
    property string badcolor: VColor.cViaviColorRed
    property string nocolor: VColor.cViaviColorLogoPurple
    property int triggerLow: 20
    property int triggerHigh: 80
    property bool haveTrigger: false

    function get_color(pcent) {
        if (!haveTrigger)
            return nocolor

        if (pcent < triggerLow || pcent > triggerHigh) {
            return badcolor
        }

        return goodcolor
    }

    Rectangle {
        width: parent.width
        height: parent.height
        z: 0

        Rectangle {
            anchors.fill: parent
            border.width: 2
            border.color: VColor.cViaviColorLightGray2
        }

        Rectangle {
            z: 1
            border.color: VColor.cViaviColorLightGray2
            border.width: 2
            x: landscape ? (triggerLow * ((parent.width) / 100)) : 0
            y: landscape ? 0 : (triggerLow * ((parent.height) / 100))
            width: landscape ? ((parent.width) / 100) * (triggerHigh - triggerLow) : (parent.width)
            height: landscape ? parent.height : ((triggerHigh - triggerLow) * ((parent.height) / 100))
        }

        Rectangle {
            radius: 5
            id: rec
            color: get_color(pourcentage)
            z : 2
            x : 5
            y: ((landscape) ? 5 : (100 - pourcentage) * ((parent.height - 10) / 100))
            width: landscape ? ((parent.width - 10) / 100) * pourcentage : (parent.width - 10)
            height: landscape ? (parent.height - 10) : parent.height - y - 10
            Behavior on color {
                ColorAnimation { duration: 100 }
            }
            Behavior on y {
                NumberAnimation { duration: 100 }
            }
            Behavior on width {
                NumberAnimation { duration: 100 }
            }
        }
    }
}
