<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\otau;

use app\util\SMTLogger;

use app\parser\SMTOtuSocket;

use app\parser\SMTOtuApi;

/**
 *
 * @author Sylvain Desplat
 *
 */
class SMTMacroSwitchConf extends SMTMacroSwitch
{    
    /**
     * 
     * @param app\parser\SMTOtuSocket $socket
     */
    function __construct( SMTOtuSocket $socket )
    {
        parent::__construct($socket);
    }
    
    /**
     * Not used
     */
    protected function retrieveGlobal()
    {
        $result = $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_switch_config_desc, SMTSwitchManager::MACRO_SWITCH_ID, parent::GLOB ) );
        list( $device, $code, $test ) = explode(',', $result);        
        $this->setSwitchDecoder( parent::GLOB, $code );
        
        // distributor OSX musn't be fetched twice
        $hasDistributor = $this->getSwitchDecoder( parent::GLOB)->hasOSUDistributor();
        $nbOsx = $this->getSwitchDecoder( parent::GLOB)->getOSUCount();
        if ( $hasDistributor && ($nbOsx >= self::OSU_DISTRIBUTOR_INDEX) )
        {
        	$nbOsx = self::OSU_DISTRIBUTOR_INDEX -1 ;
        }
        
        if ( $this->getSwitchDecoder( parent::GLOB)->hasPortsDistributorAtEnd() )
        {
            $result = $this->socket->sendReceive( SMTOtuApi::CMD_get_Nb_Port_Distributeur );
            $this->getSwitchDecoder( parent::GLOB)->setPortDistributorNumber( intval( $result ) );
        }
        
        //retrieve OSU if needed: WARNING only retrieve OSU1 and OSU2 in simplified mode
        for ( $osuCount = 1; $osuCount <= $nbOsx; $osuCount++)
        {
            $result = $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_switch_config_desc, SMTSwitchManager::MACRO_SWITCH_ID, parent::OSU.$osuCount ) );
            list( $device, $code, $test ) = explode(',', $result);
            $this->setSwitchDecoder( parent::OSU.$osuCount, $code );
        }
         
        //distributor OSU is at address 31
        if ( $hasDistributor)
        {
        	$result = $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_switch_config_desc, SMTSwitchManager::MACRO_SWITCH_ID, $this->getSwitchDecoder( parent::GLOB)->getOSUDistributor() ) );
            list( $device, $code, $test ) = explode(',', $result);
            $this->setSwitchDecoder( parent::OSU_DISTRIBUTOR, $code );
        }
    }

    /**
     * Retrieve internal switch and build Dto
     *  
     */
    protected function retrieveInternal()
    {
        $result = trim( $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_switch_config_desc, SMTSwitchManager::MACRO_SWITCH_ID, parent::INTERNAL ) ) );
        
        if ( ($result != "") && ($result != "0") ) 
        {
            list( $device, $code, $test ) = explode(',', $result);
            
            
            SMTLogger::getInstance()->trace("device: $device code: $code test: $test");
            
            $code = trim($code);
            
            if ( $code != "" )
            {
                SMTLogger::getInstance()->trace("code: $code");
                $this->setSwitchDecoder( parent::INTERNAL, $code );        
                $this->serialNumber = $this->socket->sendReceive( sprintf( SMTOtuApi::CMD_switch_config_SerialNum, SMTSwitchManager::MACRO_SWITCH_ID, parent::INTERNAL ) );
                
                $this->internalSwitchHasLicense = $this->isInternalSwitchWithLicence();
                if ( $this->internalSwitchHasLicense )
                {
                    $this->internalSwitchOutPut = $this->getInternalSwitchTotalPorts();
                }
            }
        }                
    }
    
    /**
     * Retrieve internal switch and build Dto
     *
     */
    protected function updateOSXSerialNumbers()
    {
    	$result = trim( $this->socket->sendReceive( SMTOtuApi::CMD_switch_config_Serial_Number_List) );
    	if ( $result != "" )
    	{
    		$serialNumberList = explode(',', $result);
    		if (is_array($serialNumberList) && count($serialNumberList) > 0 )
    		{
	    		foreach ( $this->switchesDto as &$switchDto) 
	    		{
	    			if ($switchDto->getIndex() == self::OSU_DISTRIBUTOR_INDEX)
	    			{
	    				$switchDto->setSerialNumber( end($serialNumberList) );
	    			}
	    			else if ( $switchDto->getIndex() > 0) 
	    			{
	    				//SMTLogger::getInstance()->trace(sprintf("serialNumberList[switchDto->getIndex() - 1]: %d", $serialNumberList[$switchDto->getIndex() - 1]), SMTLogger::INFO);
	    				$switchDto->setSerialNumber( $serialNumberList[$switchDto->getIndex() - 1] );
	    			}
	    		}
    		}
    	}
    }
    
    function hasMolexOSU()
    {
    	if ( $this->getSwitchDecoder( self::GLOB) == NULL )
    	{
    		$result = $this->socket->sendReceive( SMTOtuApi::CMD_get_osu_conf_type );
    		return strcasecmp('MOLEX', $result) == 0;
    	}
    	
    	return ($this->getSwitchDecoder( self::GLOB) != NULL)? $this->getSwitchDecoder( self::GLOB)->hasMolexOSU(): FALSE;
    }
    
    function hasJdsuOSU()
    {
    	if ( $this->getSwitchDecoder( self::GLOB) == NULL )
    	{
    		$result = $this->socket->sendReceive( SMTOtuApi::CMD_get_osu_conf_type );
    		return strcasecmp('JDSU', $result) == 0;
    	}
    	
    	return ($this->getSwitchDecoder( self::GLOB) != NULL)? $this->getSwitchDecoder( self::GLOB)->hasJdsuOSU(): FALSE;
    }
    
    function hasUOS()
    {
        $hasUOS = FALSE;
        if ( $this->getSwitchDecoder( self::GLOB) == NULL )
        {
            $result = $this->socket->sendReceive( SMTOtuApi::CMD_get_osu_det_type );
            $hasUOS = ( strcasecmp('UOS', $result) == 0);
        }
        else
        {
            $hasUOS= $this->getSwitchDecoder( self::GLOB)->hasUOS();
            if ( !$hasUOS && ($this->getSwitchDecoder( self::OSU ."1") != NULL) )
            {
                $hasUOS= $this->getSwitchDecoder( self::OSU ."1")->hasUOS();
            }
        }
        
        return $hasUOS;
    }
    
    function retrieveUOSLicense()
    {
        if ($this->hasUOS())
        {
            $this->hdosSwitchHasLicense = $this->isHDOSSwitchWithLicence();
            if ( $this->hdosSwitchHasLicense )
            {
                $this->hdosSwitchTotalOutPut = $this->getHDOSSwitchTotalPorts();
            }
        }
    }
    
    /**
     * Retrieve internal switch and build the switch Dto
     * 
     * @param SMTOtuSocket $socket 
     * 
     * @return SMTMacroSwitchConf
     */
    static function retrieve( SMTOtuSocket $socket )
    {
        $macroSwitchConf = new SMTMacroSwitchConf($socket);
        $macroSwitchConf->retrieveGlobal();
    	$macroSwitchConf->retrieveInternal();
    	$macroSwitchConf->retrieveUOSLicense();
    	$macroSwitchConf->buildSwitchDto( FALSE );
    	$macroSwitchConf->updateOSXSerialNumbers();
    	
    	return $macroSwitchConf;
    }  
}
?>