'''
StrataSync metadata definitions for the
OTDR test.type
schemaVersion 1.4.0

cdmPath is specified using JsonPath format
TODO check licensing for https://goessner.net/articles/JsonPath/
'''

from fiber.common import transform_wavelength



__test_type__ = "OTDR"
__cdm_version__ = "2.1"
__schema_version__ = "1.4.0"
__rules__ = [
    {
        "cdmPath": "$.tests[0].results.data.otdrResults.measuredResults[*].wavelengthNm",
        "metadataKey": "fiberWavelengths",
        "formatter": transform_wavelength
    },
    {
        "cdmPath": "$.tests[0].results.data.otdrResults.measuredResults[0].fiberLength",
        "metadataKey": "fiberTotalLength"
    },
    {
        "cdmPath": "$.tests[0].results.data.otdrResults.measuredResults[0].linkLossdB",
        "metadataKey": "fiberTotalLoss"
    },
    {
        "cdmPath": "$.tests[0].results.data.otdrResults.measuredResults[0].linkOrldB",
        "metadataKey": "fiberLinkOrl"
    },
    {
        "cdmPath": "$.tests[0].results.data.otdrResults.measuredResults[0].acqDateTime",
        "metadataKey": "fiberAcqDate"
    },
    {
        "cdmPath": "$.tests[0].configuration.otdrSettings.fiber.locationA",
        "metadataKey": "loc"
    },
    {
        "cdmPath": "$.tests[0].configuration.otdrSettings.fiber.locationB",
        "metadataKey": "locB"
    },
    {
        "cdmPath": "$.tests[0].configuration.otdrSettings.fiber.direction",
        "metadataKey": "fiberDirection"
    },
    {
        "cdmPath": "$.tests[0].configuration.otdrSettings.fiber.number",
        "metadataKey": "fiberNumber"
    },
    {
        "cdmPath": "$.tests[0].configuration.otdrSettings.fiber.fiberId",
        "metadataKey": "fiberId"
    },
    {
        "cdmPath": "$.tests[0].configuration.otdrSettings.fiber.cableId",
        "metadataKey": "cableId"
    },
    {
        "cdmPath": "$.tests[0].configuration.otdrSettings.fiber.fiberLabel",
        "metadataKey": "fiberLabel"
    }
]
