'''
StrataSync metadata definitions for the
OptiTrak test.type
schemaVersion 1.0.0

cdmPath is specified using JsonPath format
TODO check licensing for https://goessner.net/articles/JsonPath/

'''

from fiber.common import transform_wavelength

    

__test_type__ = "optiTrak"
__cdm_version__ = "2.2"
__schema_version__ = "1.0.0"
__rules__ = [
    {
        "cdmPath": "$.tests[0].results.data.measuredCertification[*].wavelengthNm",
        "metadataKey": "fiberWavelengths",
        "formatter": transform_wavelength
    },
    {
        "cdmPath": "$.tests[0].results.data.measuredCertification[0].fiberLength",
        "metadataKey": "fiberTotalLength"
    },
    {
        "cdmPath": "$.tests[0].results.data.measuredCertification[0].linkLossdB",
        "metadataKey": "fiberTotalLoss"
    },
    {
        "cdmPath": "$.tests[0].results.data.measuredCertification[0].linkOrldB",
        "metadataKey": "fiberLinkOrl"
    },
    {
        "cdmPath": "$.tests[0].results.data.measuredCertification[0].acqDateTime",
        "metadataKey": "fiberAcqDate"
    },
    {
        "cdmPath": "$.tests[0].configuration.certificationSettings.fiber.locationA",
        "metadataKey": "loc"
    },
    {
        "cdmPath": "$.tests[0].configuration.certificationSettings.fiber.locationB",
        "metadataKey": "locB"
    },
    {
        "cdmPath": "$.tests[0].configuration.certificationSettings.fiber.direction",
        "metadataKey": "fiberDirection"
    },
    {
        "cdmPath": "$.tests[0].configuration.certificationSettings.fiber.number",
        "metadataKey": "fiberNumber"
    },
    {
        "cdmPath": "$.tests[0].configuration.certificationSettings.fiber.fiberId",
        "metadataKey": "fiberId"
    },
    {
        "cdmPath": "$.tests[0].configuration.certificationSettings.fiber.cableId",
        "metadataKey": "cableId"
    },
    {
        "cdmPath": "$.tests[0].configuration.certificationSettings.fiber.fiberLabel",
        "metadataKey": "fiberLabel"
    }
]
