
'''
StrataSync metadata definitions
Common formatter routines for Fiber domain test types
'''

from typing import List


def transform_wavelength(wavelengths: List[str]) -> str:
    out = list()

    for wavelength in wavelengths:
        out.append("{}nm".format(wavelength))

    return ";".join(out)


CONFIG_RULES = [
    {
        "cdmPath": "$.tests[0].configuration.fiber.locationA",
        "metadataKey": "loc"
    },
    {
        "cdmPath": "$.tests[0].configuration.fiber.locationB",
        "metadataKey": "locB"
    },
    {
        "cdmPath": "$.tests[0].configuration.fiber.direction",
        "metadataKey": "fiberDirection"
    },
    {
        "cdmPath": "$.tests[0].configuration.fiber.number",
        "metadataKey": "fiberNumber"
    },
    {
        "cdmPath": "$.tests[0].configuration.fiber.fiberId",
        "metadataKey": "fiberId"
    },
    {
        "cdmPath": "$.tests[0].configuration.fiber.cableId",
        "metadataKey": "cableId"
    },
    {
        "cdmPath": "$.tests[0].configuration.fiber.fiberLabel",
        "metadataKey": "fiberLabel"
    }
]