'''
StrataSync metadata definitions for the
bidirIlOrl test.type
schemaVersion 1.1.0

cdmPath is specified using JsonPath format
TODO check licensing for https://goessner.net/articles/JsonPath/
'''
from fiber.common import transform_wavelength, CONFIG_RULES


__test_type__ = "bidirIlOrl"
__cdm_version__ = "2.2"
__schema_version__ = "1.1.0"
__rules__ = [
    {
        "cdmPath": "$.tests[0].results.data.measuredResults[*].wavelengthNm",
        "metadataKey": "fiberWavelengths",
        "formatter": transform_wavelength
    },
    {
        "cdmPath": "$.tests[0].results.data.fiberLengthM",
        "metadataKey": "fiberTotalLength"
    },
    {
        "cdmPath": "$.tests[0].results.data.measuredResults[0].worstOrl",
        "metadataKey": "fiberWorstOrl"
    },
    {
        "cdmPath": "$.tests[0].results.data.measuredResults[0].averageLossdB",
        "metadataKey": "fiberAverageIl"
    },
    *CONFIG_RULES
]
