from viavi.evm import *
from viavi.diag import *
import subprocess
import sys
import time

@DIAG("Test RTC")
def t_rtc(cmd):
    try:
        (command,dateset) = cmd.split()
    except:
        print_error("# Command must be: t_rtc <MMDDhhmmYYYY.ss>")
        return False

    p = subprocess.Popen("date " + dateset, shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    rc = p.wait()
    output = p.stdout.read()
    print_info("# %s"% (output.decode("utf-8").strip()))
    time_updatertc = time.time()
    p = subprocess.Popen("hwclock --systohc" , shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    rc = rc + p.wait()
    output = p.stdout.read()
    print_info("# %s"% (output.decode("utf-8").strip()))
    time.sleep(3)
    p = subprocess.Popen("hwclock --hctosys" , shell=True, stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, close_fds=True)
    rc = rc + p.wait()
    output = p.stdout.read()
    print_info("# %s"% (output.decode("utf-8").strip()))
    deltatime = time.time() - time_updatertc
    if (deltatime > 5) or (deltatime < 2):
        print_error("# Error RTC stucked deltatime=%f s"%(deltatime))
        return False
    if(rc==0):
        print_ok("# RTC updated")
        return True
    else:
        print_ok("# Failed update RTC")
        return False
