import QtQuick 2.1
import common 1.0
import graph_plugin 1.0

Item { id: root

    property GraphPlot plot
    property alias textColor: label.color

    property bool __rightHanded: (GraphCursor.index == 0) ? (GraphCursor.xPosOnScreen < width) : (GraphCursor.xPosOnScreen+width < GraphCursor.cursor.width)
    property bool __overHanded: GraphCursor.peak ? (GraphCursor.yPosOnScreen > label.height) : (GraphCursor.yPosOnScreen+height > GraphCursor.cursor.height)
    property string __text: GraphCursor.formattedYValue

    GraphCursor.plot: plot
    visible: plot.visible && plot.valid
    x: __rightHanded ? GraphCursor.xPosOnScreen : GraphCursor.xPosOnScreen - width + 6
    y: __overHanded ? GraphCursor.yPosOnScreen - height + 6 : GraphCursor.yPosOnScreen
    width: label.width + 34
    height: label.height + 6

    states: [
        State {
            name: "1"
            when: __rightHanded && __overHanded
            PropertyChanges {
                target: flag.border
                left: 26
                right: 8
            }
        },
        State {
            name: "2"
            when: !__rightHanded && __overHanded
            PropertyChanges {
                target: flag.border
                left: 4
                right: 30
            }
        },
        State {
            name: "3"
            when: !__rightHanded && !__overHanded
            PropertyChanges {
                target: flag.border
                left: 4
                right: 30
            }
        },
        State {
            name: "4"
            when: __rightHanded && !__overHanded
            PropertyChanges {
                target: flag.border
                left: 26
                right: 8
            }
        }
    ]

    BorderImage { id: flag
        source: theme.dynamicDirPrefix + "graph_flag_" + parent.state
        anchors.fill: parent
        border.top: 0
        border.bottom: 6
        opacity: 0.65
    }

    Text { id: label
        x: flag.border.left
        y: flag.border.top
        text: root.__text
        color: plot.penColor
        font.pixelSize: 20
    }
}
