import QtQuick 2.9
import QtQuick.Templates 2.2 as T
import com.viavi.style 1.0

T.Button {
    id: root

    property color backgroundColor: ViaviStyle.theme.clickableBackground
    property color backgroundColorDisabled: ViaviStyle.theme.clickableBackgroundDisabled
    property color pressedBackgroundColor: ViaviStyle.theme.clickableBackgroundPressed
    
    property color textColor: ViaviStyle.theme.clickableForeground
    property color textColorDisabled: ViaviStyle.theme.clickableForegroundDisabled
    property color pressedTextColor: ViaviStyle.theme.clickableForegroundPressed
    
    property color borderColor: ViaviStyle.theme.border
    property int borderWidth: ViaviStyle.layout.borderWidth

    property alias labelElide: label.elide
    property alias labelFontSizeMode: label.fontSizeMode
    property alias labelMinimumPixelSize: label.minimumPixelSize


    font: ViaviStyle.layout.mediumFont
    text: ""

    implicitWidth: Math.max(background.implicitWidth, contentItem.implicitWidth + 3 * padding)
    implicitHeight: Math.max(background.implicitHeight, contentItem.implicitHeight + 1 * padding)

    padding: ViaviStyle.layout.mediumMargin

    contentItem: Label {
        id: label

        verticalAlignment: Label.AlignVCenter
        horizontalAlignment: Label.AlignHCenter

        font: root.font
        text: root.text
        color: {
            if(!root.enabled)
            {
                return root.textColorDisabled;
            }
            return root.pressed ? root.pressedTextColor : root.textColor
        }
    }

    FontMetrics {
        id: fontMetrics
        font: root.font
    }

    background: Rectangle {
        id: backgroundRect

        implicitWidth: ViaviStyle.layout.defaultButtonWidth
        implicitHeight: ViaviStyle.layout.defaultButtonHeight

        border.color: borderColor
        border.width: borderWidth

        color: {
            if(!root.enabled)
            {
                return root.backgroundColorDisabled;
            }
            return root.pressed ? root.pressedBackgroundColor : root.backgroundColor
        }
    }
}