import QtQuick 2.9
import QtQuick.Controls 2.2
import QtQuick.Layouts 1.2
import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.jobmanager_ui 1.0

Rectangle {
    id: root

    // A list of test properties to be displayed if enough space
    property var preferredTestProperties: []

    // Out of the preferred properties mentioned above, how many of them should always be visible(even if not enough space)
    property int preferredTestPropertiesAlwaysVisible: 1

    // Column names
    property string testTypeHeader: ""
    property var preferredTestPropertiesHeaders: ({})
    property string testStatusHeader: qsTr("Status")
    property string testSyncHeader: qsTr("Sync")

    // Provides widths for the columns. If no calculator is provided, implicit widths will be used
    property ColumnWidthCalculator widthCalculator
    
    //Internal
    readonly property int maxTestTypeWidth: widthCalculator ? widthCalculator.maxTestTypeWidth : 0
    readonly property var maxTestPropertyWidths: widthCalculator ? widthCalculator.maxTestPropertyWidths : ({})
    readonly property int maxStatusWidth: widthCalculator ? widthCalculator.maxStatusWidth : 0


    //TODO: dynamic props to display
    //TODO: max widths for test type, status string and dynamic props

    width: parent.width
    height: rowLayout.implicitHeight * 2

    color: JobManagerStyle.testTableHeaderBackground

    RowLayout {
        id: rowLayout

        anchors.left: parent.left
        anchors.right: parent.right

        anchors.verticalCenter: parent.verticalCenter

        spacing: ViaviStyle.layout.mediumMargin

        Item {
            id: launchIcon

            Layout.margins: JobManagerStyle.testRowMargins
            Layout.preferredWidth: JobManagerStyle.launchIconSize.width
            Layout.preferredHeight: 0
        }

        Label {
            id: testType

            Layout.preferredWidth: maxTestTypeWidth !== 0 ? maxTestTypeWidth : implicitWidth
            Layout.preferredHeight: implicitHeight

            font: JobManagerStyle.testHeaderFont
            text: testTypeHeader
            color: JobManagerStyle.testTableHeaderForeground
        }

        Item {
            id: optionalProperties

            Layout.fillWidth: true
            Layout.preferredHeight: testType.height

            RowLayout {
                id: testOptionalPropertiesRow
                anchors.fill: parent

                spacing: 0

                Repeater {
                    model: root.preferredTestProperties

                    Label {
                        Layout.alignment: Qt.AlignHCenter
                        Layout.preferredWidth: {
                            var w = implicitWidth;
                            if(modelData in maxTestPropertyWidths)
                            {
                                w = maxTestPropertyWidths[modelData];
                            }

                            if(index < preferredTestPropertiesAlwaysVisible)
                            {
                                var availableWidth = testOptionalPropertiesRow.width;
                                for(var i = 0; i < index; ++i)
                                {
                                    availableWidth -= maxTestPropertyWidths[root.preferredTestProperties[i]];
                                }

                                return Math.min(w, Math.max(availableWidth, 0));
                            }

                            return Math.min(w, testOptionalPropertiesRow.width / preferredTestPropertiesAlwaysVisible);
                        }

                        opacity: (index <= preferredTestPropertiesAlwaysVisible - 1 || x + width <= testOptionalPropertiesRow.width) ? 1.0 : 0.0
                        elide: Label.ElideRight

                        color: JobManagerStyle.testTableHeaderForeground
                        font: JobManagerStyle.testHeaderFont
                        text: modelData in preferredTestPropertiesHeaders ? preferredTestPropertiesHeaders[modelData] : modelData
                    }
                }
            }
        }

        Label {
            id: testStatus

            Layout.preferredWidth: maxStatusWidth !== 0 ? maxStatusWidth : implicitWidth
            Layout.preferredHeight: implicitHeight
            Layout.margins: JobManagerStyle.testRowMargins

            color: JobManagerStyle.testTableHeaderForeground
            font: JobManagerStyle.testHeaderFont
            text: testStatusHeader
        }

        Label {
            id: syncIcon

            Layout.preferredWidth: JobManagerStyle.syncStatusIconSize.width
            Layout.margins: JobManagerStyle.testRowMargins
            visible: JobManagerStyle.config.showTestSyncIcon

            horizontalAlignment: Label.AlignHCenter

            color: JobManagerStyle.testTableHeaderForeground
            font: JobManagerStyle.testHeaderFont
            text: root.testSyncHeader
        }

        Item {
            id: moreOptions
            visible: JobManagerStyle.config.showMoreOptions
            
            Layout.preferredWidth: JobManagerStyle.moreTestOptionsIconSize.width
            Layout.preferredHeight: 0
            Layout.rightMargin: ViaviStyle.layout.mediumMargin
        }
    }
}
