import QtQuick 2.9
import QtQuick.Controls 2.2
import QtQuick.Layouts 1.2
import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.jobmanager_ui 1.0

Rectangle {
    id: root

    property Job job
    property alias testModel: testList.model

    // Holds the number of tests displayed on screen
    readonly property alias testRowCount: testList.count

    property string tableTitle: qsTr("Table")
    property string testTypeHeader: qsTr("Test")

    property var preferredTestProperties: JobManagerStyle.config.preferredTestProperties
    property int preferredTestPropertiesAlwaysVisible: JobManagerStyle.config.preferredTestPropertiesAlwaysVisible
    property var preferredTestPropertiesHeaders: {
        if(!job)
        {
            return JobManagerStyle.config.testPropertyDisplayNames;
        }

        // Default values come from the testPropertyDisplayInfos labels
        var headers = {};
        for(var key in job.testPropertyDisplayInfos)
        {
            headers[key] = job.testPropertyDisplayInfos[key].label;
        }

        // Override with values specified by the user
        for(var key in JobManagerStyle.config.testPropertyDisplayNames)
        {
            headers[key] = JobManagerStyle.config.testPropertyDisplayNames[key];
        }

        return headers;
    }

    width: parent.width
    height: childrenRect.height + ViaviStyle.layout.smallMargin
    color: JobManagerStyle.testTableBackground

    ColumnWidthCalculator {
        id: calculator

        testModel: root.testModel
        preferredTestProperties: root.preferredTestProperties

        testTypeHeaderString: tableHeader.testTypeHeader
        preferredTestPropertiesHeaders: root.preferredTestPropertiesHeaders
        testStatusHeaderString: tableHeader.testStatusHeader
    }

    Column {
        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layout.mediumMargin
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layout.mediumMargin

        spacing: ViaviStyle.layout.mediumMargin
        topPadding: ViaviStyle.layout.mediumMargin

        Label {
            id: tableTitleLabel

            width: parent.width
            horizontalAlignment: Label.AlignHCenter

            font: ViaviStyle.layout.largeBoldFont
            text: root.tableTitle
        }

        TestTableHeader {
            id: tableHeader

            preferredTestProperties: root.preferredTestProperties
            preferredTestPropertiesAlwaysVisible: root.preferredTestPropertiesAlwaysVisible
            preferredTestPropertiesHeaders: root.preferredTestPropertiesHeaders
            testTypeHeader: root.testTypeHeader
            widthCalculator: calculator
        }

        TestTableRow {
            id: dummyRow
            visible: false
        }

        ListView {
            id: testList

            width: parent.width
            height: Math.max(childrenRect.height, testRowCount * dummyRow.height)

            visible: count > 0
            spacing: 0
            interactive: false

            delegate: Loader {
                id: loader
                width: parent.width
                asynchronous: index > 20

                sourceComponent: TestTableRow {
                    id: testRow

                    job: root.job
                    test: model.test ? model.test : null
                    preferredTestProperties: root.preferredTestProperties
                    preferredTestPropertiesAlwaysVisible: root.preferredTestPropertiesAlwaysVisible
                    buttonsEnabled: job ? !job.isArchived : true
                    widthCalculator: calculator

                    Rectangle {
                        anchors.bottom: parent.bottom

                        width: parent.width
                        height: ViaviStyle.layout.borderWidth
                        color: JobManagerStyle.testTableHeaderBackground
                    }
                }
            }
        }


        Label {
            id: noTestsMessage

            width: parent.width
            visible: testRowCount === 0

            font: ViaviStyle.layout.largeBoldFont
            text: qsTr("No tests")
        }
    }
}