import QtQuick 2.12
import QtQuick.Controls 2.2
import QtQuick.Layouts 1.2
import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.jobmanager_ui 1.0

Item {
    id: root
    property Job job
    property int groupType: TestGroupType.NONE
    property alias testModel: testsView.model
    property int maxNumberOfVisibleTests: 50
    height: testsView.height
    visible: testsView.count > 0
    clip: true

    ListView {
        id: testsView
        anchors.top: parent.top
        width: parent.width
        height: count > root.maxNumberOfVisibleTests ? Math.min(JobManagerStyle.config.windowHeight * 0.65, contentHeight) : contentHeight

        ScrollBar.vertical: JobManagerScrollBar { id: scrollBar; }
        contentWidth: parent.width - (scrollBar.visible ? scrollBar.width : 0)

        boundsMovement: Flickable.StopAtBounds
        boundsBehavior: Flickable.DragAndOvershootBounds
        
        visible: count > 0
        spacing: root.groupType !== TestGroupType.NONE ? 0 : ViaviStyle.layout.mediumMargin + ViaviStyle.layout.largeMargin

        delegate: Loader {                  
            id: itemDelegateLoader
            width: testsView.contentWidth
            property string previousSection: ListView.previousSection
            property string currentSection: ListView.section
            property string nextSection: ListView.nextSection

            sourceComponent: Item {
                width: parent.width
                height: partialRect.height + (partialRect.type === PartialRectangle.BOTTOM ? ViaviStyle.layout.mediumMargin : 0)
                PartialRectangle {
                    id: partialRect
                    borderWidth: JobManagerStyle.cardBorderWidth
                    width: parent.width
                    height: delegateColumn.height + ViaviStyle.layout.mediumMargin
                    radius: JobManagerStyle.cardCornerRadius
                    anchors.top: parent.top
                    type: {
                        if((previousSection !== "" && nextSection !== currentSection) ||  
                        (previousSection == currentSection && nextSection !== currentSection ) ||
                        (previousSection === "" && nextSection !== currentSection) || root.groupType === TestGroupType.NONE)
                        {
                            return PartialRectangle.BOTTOM;
                        }
                        return PartialRectangle.MIDDLE;
                    }
                    Column {
                        id: delegateColumn
                        width: parent.width

                        Item {
                            height: descriptionText.visible ? (descriptionText.height + ViaviStyle.layout.smallMargin) : 0
                            width: parent.width

                            Label {
                                id: descriptionText
                                anchors.left: parent.left
                                anchors.leftMargin: ViaviStyle.layout.veryLargeMargin
                                anchors.right: parent.right
                                text: {
                                    if(root.job && root.job.getTestDescriptionByTestIndex(currentSection) !== "")
                                    {
                                        return "   " + root.job.getTestDescriptionByTestIndex(currentSection);
                                    }
                                    else return "";
                                }
                                visible: (itemDelegateLoader.currentSection !== itemDelegateLoader.previousSection) && text !== "" && root.groupType === TestGroupType.DEFAULT_VIEW && root.job.getTestTypeByTestIndex(currentSection) !== "manual"
                                font: ViaviStyle.layout.mediumFont
                                elide: Label.ElideRight
                            }
                        }

                        TestEntry {
                            id: testEntry
                            width: parent.width
                            job: root.job
                            test: model.test ? model.test : null
                        }
                    }

                    Rectangle {
                        id: testEntrySeparator
                        width: parent.width * 0.96
                        height: 2
                        color: "gray"
                        anchors.topMargin: ViaviStyle.layout.smallMargin / 2
                        anchors.top: delegateColumn.bottom
                        anchors.horizontalCenter: parent.horizontalCenter
                        visible: root.groupType !== TestGroupType.NONE && partialRect.type !== PartialRectangle.BOTTOM
                    }
                }
            }
        }
        
        section.property: root.getSectionProperty()
        section.criteria: ViewSection.FullString
        section.delegate: PartialRectangle {
            id: sectionPartialRect
            type: PartialRectangle.TOP
            radius: JobManagerStyle.cardCornerRadius
            borderWidth: JobManagerStyle.cardBorderWidth
            width: testsView.contentWidth
            height: sectionColumn.height + ViaviStyle.layout.smallMargin
            Label {
                id: requiredTestMarker
                anchors.left: parent.left
                anchors.top: parent.top
                anchors.leftMargin: ViaviStyle.layout.largeMargin
                anchors.topMargin: ViaviStyle.layout.smallMargin
                text: "*"
                color: ViaviColor.red
                visible: {
                    if(!root.job)
                    {
                        return false;
                    }
                    if(root.groupType === TestGroupType.DEFAULT_VIEW)
                    {
                        if(root.job.testLocationsNumberByIndex(section) < 0)
                        {
                            return false;
                        }
                        else if(root.job.testLocationsNumberByIndex(section) === 0)
                        {
                            return true;
                        }
                    }
                    else if(root.groupType === TestGroupType.GROUPBY_TEST_NAME)
                    {
                        if(root.job.testLocationsNumberByDisplayName(section) === 1 && root.job.countTestsByDisplayName(section) === 1)
                        {
                            return true;
                        }
                        else return false;
                        
                    }
                    return false;
                }
                font: ViaviStyle.layout.mediumBoldFont
            }
            Column {
                id: sectionColumn
                anchors.left: requiredTestMarker.visible ? requiredTestMarker.left : parent.left
                anchors.leftMargin: requiredTestMarker.visible ? ViaviStyle.layout.mediumMargin : ViaviStyle.layout.largeMargin
                anchors.top: parent.top
                anchors.topMargin: ViaviStyle.layout.smallMargin
                spacing: 0
                height: sectionText.contentHeight
                Label {
                    id: sectionText
                    text: { 
                        if(root.job && root.groupType === TestGroupType.DEFAULT_VIEW)
                        {
                            return root.job.getTestNamebyTestIndex(section);
                        }
                        if(section === "~")
                            return qsTr("No Location");
                        else return section;
                    }
                    font: ViaviStyle.layout.mediumBoldFont
                }
            }
        }
    }

    function getSectionProperty()
    {
        if(root.groupType === TestGroupType.GROUPBY_LOCATION)
        {
            return "test.location";
        }
        else if(root.groupType === TestGroupType.GROUPBY_TEST_NAME)
        {
            return "test.testTypeDisplayName";
        }
        else if(root.groupType === TestGroupType.DEFAULT_VIEW)
        {
            return "test.testIndex";
        }
        return ""
    }
}