import QtQuick 2.0
// import com.viavi.jobmanager_ui 1.0
import com.viavi.style 1.0

Rectangle {
    id: root; color: "#DBDBDB"; height: 250 * JobManagerStyle.keyboardHeightScale + 30
    property bool isShift: false
    property bool isShiftLock: false
    property real keyWidth: (width - 20) / 4
    property int maxLength: 57

    signal sigEntered(string value)
    signal sigCanceled()

    QtObject {
        id: internal

        property var editedItem: externalTextItem ? externalTextItem : textEdit
        property var externalTextItem: null
        property string externalTextItemInitialValue: ""
    }

    Connections {
        target: internal.externalTextItem
        onEnabledChanged: {
            close();
        }

        onFocusChanged: {
            close();
        }
    }

    function open(init, z) 
    { 
        isShift = false; 
        isShiftLock = false; 
        internal.externalTextItem = null;
        internal.editedItem.focus = true; 
        internal.editedItem.text = init; 
        internal.editedItem.cursorPosition = internal.editedItem.text.length; 
        root.z = z + 1; 
        visible = true; 
    }

    function openDirectEdit(textItem)
    {
        internal.externalTextItem = textItem;
        internal.externalTextItemInitialValue = textItem.text;

        isShift = false; 
        isShiftLock = false; 
        internal.externalTextItem.focus = true; 
        internal.externalTextItem.cursorPosition = internal.externalTextItem.text.length; 
        root.z = z + 1; 
        visible = true; 
    }

    function close() 
    { 
        internal.editedItem.focus = false; 
        internal.externalTextItem = null;
        visible = false; 
    }

    // Internal
    function append(n) { internal.editedItem.insert(internal.editedItem.cursorPosition, n); if (!isShiftLock) isShift = false; }
    function getKeyWidth(n) { return n * (keyWidth + 5) - 5; }
    function enter() { sigEntered(internal.editedItem.text); close(); }
    function cancel() 
    { 
        if(internal.externalTextItem)
        {
            internal.externalTextItem.text = internal.externalTextItemInitialValue;
        }

        sigCanceled(); 
        close(); 
    }


    Column { anchors { fill: parent; margins: 5 } spacing: 5
        Row { spacing: 5
            Rectangle { width: getKeyWidth(3); height: 50 * JobManagerStyle.keyboardHeightScale; clip: true; color: "#FFFFFF"
                TextEdit { id: textEdit; anchors.centerIn: parent; focus: true; font.family: ViaviStyle.layout.fontFamily; font.pixelSize: 24
                    property string prevText: text;
                    Keys.onEnterPressed: enter(); Keys.onEscapePressed: close(); Keys.onReturnPressed: enter(); 
                    onTextChanged: { if (maxLength && text.length > maxLength) { var p = cursorPosition; text = prevText; cursorPosition = Math.min(text.length, p - 1) } prevText = text; }
                }
            }
            Key { width: keyWidth; text: "Clear"; onClicked: internal.editedItem.clear() }
        }
        Row { spacing: 5
            Key { width: keyWidth; text: isShift ? "7" : "7"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "8" : "8"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "9" : "9"; onClicked: append(text) }
            Key { width: keyWidth; img: "keyboard-delete-032.png"; onClicked: internal.editedItem.remove(internal.editedItem.cursorPosition - 1, internal.editedItem.cursorPosition) }
        }
        Row { spacing: 5
            Key { width: keyWidth; text: isShift ? "4" : "4"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "5" : "5"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "6" : "6"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "-" : "-"; onClicked: append(text) }
        }
        Row { spacing: 5
            Key { width: keyWidth; text: isShift ? "1" : "1"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "2" : "2"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "3" : "3"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "." : "."; onClicked: append(text) }
        }
        Row { spacing: 5
            Key { width: keyWidth; text: isShift ? "0" : "0"; onClicked: append(text) }
            Key { width: keyWidth; isApply: true; text: "Cancel"; onClicked: cancel() }
            Key { width: getKeyWidth(2); isApply: true; text: "Enter"; onClicked: enter() }
        }
    }
}
