import QtQuick 2.0
import com.viavi.style 1.0

Rectangle {
    id: root; color: "#DBDBDB"; height: 320 * JobManagerStyle.keyboardHeightScale + 35
    property bool isShift: false
    property bool isShiftLock: false
    property real keyWidth: (width - 70) / 13
    property int maxLength: 100
    property bool isFilename: false  // prevents entering: <space> ? / , ; : " < > + = and |


    QtObject {
        id: internal

        property var editedItem: externalTextItem ? externalTextItem : textEdit
        property var externalTextItem: null
        property string externalTextItemInitialValue: ""
    }

    Connections {
        target: internal.externalTextItem
        onEnabledChanged: {
            close();
        }

        onFocusChanged: {
            close();
        }
    }
    
    function open(init, z) 
    { 
        isShift = false; 
        isShiftLock = false; 
        textEdit.focus = true; 
        internal.externalTextItem = null;
        textEdit.text = init; 
        textEdit.cursorPosition = textEdit.text.length; 
        root.z = root.z + 1; 
        visible = true;
    }

    function openDirectEdit(textItem)
    {
        internal.externalTextItem = textItem;
        internal.externalTextItemInitialValue = textItem.text;
        
        isShift = false; 
        isShiftLock = false; 
        internal.externalTextItem.focus = true; 
        internal.externalTextItem.cursorPosition = internal.externalTextItem.text.length; 
        root.z = root.z + 1;
        root.visible = true;
    }

    function close()
    { 
        internal.editedItem.focus = false; 
        internal.externalTextItem = null;
        visible = false; 
    }


    // Internal
    function getKeyWidth(n) { return n * (keyWidth + 5) - 5; }
    function append(n) { internal.editedItem.insert(internal.editedItem.cursorPosition, n); if (!isShiftLock) isShift = false; }
    
    function enter() 
    { 
        sigEntered(internal.editedItem.text); 
        close();
    }

    function resetExternalText()
    {
        if(internal.externalTextItem)
        {
            internal.externalTextItem.text = internal.externalTextItemInitialValue;
        }
    }

    signal sigEntered(string name)
    signal sigClosed()
    Column { anchors { fill: parent; margins: 5 } spacing: 5
        Row { spacing: 5
            Key { width: getKeyWidth(2); text: "Clear"; onClicked: internal.editedItem.clear() }
            Rectangle { width: getKeyWidth(9); height: 50 * JobManagerStyle.keyboardHeightScale; clip: true; color: "#FFFFFF"
                TextEdit { id: textEdit; anchors.centerIn: parent; focus: true; font.family: ViaviStyle.layout.fontFamily; font.pixelSize: 24
                    property string prevText: text;
                    Keys.onEnterPressed: enter(); Keys.onEscapePressed: { sigClosed(); close()} Keys.onReturnPressed: enter(); 
                    onTextChanged: { if (maxLength && text.length > maxLength) { var p = cursorPosition; text = prevText; cursorPosition = Math.min(text.length, p - 1) } prevText = text; }
                }
            }
            Key { width: getKeyWidth(2); img: "keyboard-delete-032.png"; onClicked: internal.editedItem.remove(internal.editedItem.cursorPosition - 1, internal.editedItem.cursorPosition) }
        }
        Row { spacing: 5
            Key { width: keyWidth; text: isShift ? "~" : "`"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "!" : "1"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "@" : "2"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "#" : "3"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "$" : "4"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "%" : "5"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "^" : "6"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "&" : "7"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "*" : "8"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "(" : "9"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? ")" : "0"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "_" : "-"; onClicked: append(text) }
            Key { width: keyWidth; text: isFilename ? " " : isShift ? "+" : "="; onClicked: if (!isFilename) append(text) }
        }
        Row { spacing: 5
            Key { width: keyWidth; text: isShift ? "Q" : "q"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "W" : "w"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "E" : "e"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "R" : "r"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "T" : "t"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "Y" : "y"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "U" : "u"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "I" : "i"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "O" : "o"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "P" : "p"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "{" : "["; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "}" : "]"; onClicked: append(text) }
            Key { width: keyWidth; text: (isShift && !isFilename) ? "|" : "\\"; onClicked: append(text) }
        }
        Row { spacing: 5
            Key { width: keyWidth; text: isShift ? "A" : "a"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "S" : "s"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "D" : "d"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "F" : "f"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "G" : "g"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "H" : "h"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "J" : "j"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "K" : "k"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "L" : "l"; onClicked: append(text) }
            Key { width: keyWidth; text: isFilename ? " " : isShift ? ":" : ";"; onClicked: if (!isFilename) append(text) }
            Key { width: keyWidth; text: (isShift && !isFilename) ? "\"" : "'"; onClicked: append(text) }
            Key { width: getKeyWidth(2); isApply: true; text: "Enter"; onClicked: enter() }
        }
        Row { spacing: 5
            Key { width: keyWidth; text: isShift ? "Z" : "z"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "X" : "x"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "C" : "c"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "V" : "v"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "B" : "b"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "N" : "n"; onClicked: append(text) }
            Key { width: keyWidth; text: isShift ? "M" : "m"; onClicked: append(text) }
            Key { width: keyWidth; text: isFilename ? " " : isShift ? "<" : ","; onClicked: if (!isFilename) append(text) }
            Key { width: keyWidth; text: (isShift && !isFilename) ? ">" : "."; onClicked: append(text) }
            Key { width: keyWidth; text: isFilename ? " " : isShift ? "?" : "/"; onClicked: if (!isFilename) append(text) }
            Key { width: getKeyWidth(3); isMenu: isShift; text: "Shift"; onClicked: { isShift = !isShift; isShiftLock = false; } }
        }
        Row { spacing: 5
            Key { width: getKeyWidth(2); isMenu: isShiftLock; text: "Shift Lock"; onClicked: { isShiftLock = !isShiftLock; isShift = isShiftLock } }
            Key { width: getKeyWidth(8); onClicked: internal.editedItem.insert(internal.editedItem.cursorPosition, " ") }
            Key { width: keyWidth; text: "←"; onClicked: internal.editedItem.cursorPosition-- }
            Key { width: keyWidth; text: "→"; onClicked: internal.editedItem.cursorPosition++ }
            Key { width: keyWidth; isMenu: true; img: "keyboard-close-048.png"; onClicked: { sigClosed(); resetExternalText(); close() } }
        }
    }
}
