import QtQuick 2.0
Item {
    id: root
    enum Type {
        TOP,
        MIDDLE,
        BOTTOM
    }
    property color color: "white"
    property int radius: 0
    property int type: PartialRectangle.MIDDLE
    property int borderWidth: 1 
    
    clip: type !== PartialRectangle.MIDDLE
    
    Rectangle {
        id: background        
        anchors.top: parent.top
        anchors.topMargin: type === PartialRectangle.TOP ? 10 : 0
        width: parent.width
        height: parent.height
        radius: type !== PartialRectangle.MIDDLE ? root.radius : 0
        color: root.color
    }

    Rectangle {
        id: leftBorder
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        width: root.borderWidth
        color: "black"
        visible: type === PartialRectangle.MIDDLE
    }
    Rectangle {
        id: rightBorder
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        width: root.borderWidth
        color: "black"
        visible: type === PartialRectangle.MIDDLE
    }
    Rectangle {
        id: roundedBorder
        anchors.top: parent.top
        anchors.topMargin: type === PartialRectangle.TOP ? 0 : -parent.height
        width: parent.width
        height: parent.height * 2
        visible: type !== PartialRectangle.MIDDLE
        color: root.color
        radius: root.radius
        border.color: "black"
        border.width: root.borderWidth
    }
}