import QtQuick 2.9
import QtQuick.Controls 2.2
import QtQuick.Layouts 1.2
import com.viavi.style 1.0
import com.viavi.jobmanager_ui 1.0


Item {
    id: root
    property Test test
    width: parent.width
    height: manualTestColumn.height

    Column {
        id: manualTestColumn
        width: parent.width
        spacing: ViaviStyle.layout.smallMargin

        Label {
            id: promptLabel
            text: test && test.testConfigurationMap["prompt"] !== undefined ? test.testConfigurationMap["prompt"] : ""
            visible: test && test.testType === "manual" && text !== ""
            font: ViaviStyle.layout.mediumFont
            width: parent.width
            elide: Label.ElideRight
        }

        ComboBox {
            id: manualStepSelection
            implicitWidth: parent.width * 0.9
            font: ViaviStyle.layout.mediumFont
            model: test.testConfigurationMap["options"] !== undefined ? test.testConfigurationMap["options"] : null
            visible: test.testConfigurationMap["type"] === "selection"
            delegate: ItemDelegate {
                width: manualStepSelection.width
                contentItem: Label {
                    text: modelData
                    color: ViaviStyle.theme.clickableForeground
                    font: manualStepSelection.font
                    elide: Text.ElideRight
                    verticalAlignment: Text.AlignVCenter
                }
                highlighted: manualStepSelection.highlightedIndex === index
            }
            onActivated: {
                test.manualStepUserResponse = test.testConfigurationMap["options"][highlightedIndex];
                manualStepSelection.currentIndex = Qt.binding(function() { return manualStepSelection.find(test.manualStepUserResponse); });
            }
            Component.onCompleted: {
                manualStepSelection.currentIndex = Qt.binding(function() 
                { 
                    if(test.testConfigurationMap["options"] !== undefined)
                    { 
                        return test.testConfigurationMap["options"].indexOf(test.manualStepUserResponse);
                    }
                    return -1;
                });
            }
        }

        JobManagerTextField {
            id: textField
            text: test.manualStepUserResponse
            width: parent.width * 0.9
            enabled: true
            visible: test.testConfigurationMap["type"] === "comment"
            backgroundColor: acceptableInput ? JobManagerStyle.textEditBackgroundColor : ViaviStyle.theme.fail
            backgroundColorDisabled: JobManagerStyle.textEditBackgroundColorDisabled
            borderColor: JobManagerStyle.textEditBorderColor
            borderColorFocused: JobManagerStyle.textEditBorderColorFocused           

            onEditingFinished: {
                focus = false;
            }

            onFocusChanged: {
                if(!focus)
                {
                    console.log("Updating property...")
                    try {
                        test.manualStepUserResponse = textField.text;
                    }
                    catch (error) { 
                        console.log("Could not set manualStepUserResponse: " + error);
                    }
                    textField.text = Qt.binding(function() { return "" + test.manualStepUserResponse; });
                }
            }
        }

        Row {
            id: checkBoxRow
            width: parent.width / 2
            spacing: width / 3

            ManualTestCheckBox {
                id: controlYes
                text: qsTr("Yes")
                checked: test.manualStepUserResponse === "yes"
                visible: test.testType === "manual" && test.testConfigurationMap["type"] === "yesNo"
                onClicked: {
                    if(checked)
                    {
                        controlNo.checked = !checked
                        test.manualStepUserResponse = "yes"
                    }
                    else checked = !checked
                }
            }

            ManualTestCheckBox {
                id: controlNo
                text: qsTr("No")
                checked: test.manualStepUserResponse === "no"
                visible: test.testType === "manual" && test.testConfigurationMap["type"] === "yesNo"
                onClicked: {
                    if(checked)
                    {
                        controlYes.checked = !checked;
                        test.manualStepUserResponse = "no"
                    }
                    else checked = !checked
                }
            }
        }        
    }
}