import QtQuick 2.9
import QtQuick.Controls 2.2
import com.viavi.style 1.0
import com.viavi.style.components 1.0

CheckBox 
{
    id: control
    text: ""
    checked: false
    visible: true
    indicator: Rectangle {
        implicitWidth: JobManagerStyle.launchIconSize.width
        implicitHeight: JobManagerStyle.launchIconSize.height
        radius: 20
        border.color: ViaviColor.black
        border.width: 2
        Rectangle {
            
            anchors.centerIn: parent                    
            width: JobManagerStyle.launchIconSize.width * 0.6
            height: JobManagerStyle.launchIconSize.height * 0.6
            radius: 20
            color: control.enabled ? ViaviColor.black : ViaviColor.darkGray
            visible: control.checked
        }
    }

    contentItem: Text {
        text: control.text
        font: control.font
        opacity: enabled ? 1.0 : 0.3
        color: control.enabled ? ViaviColor.black : ViaviColor.darkGray
        verticalAlignment: Text.AlignVCenter
        topPadding: -control.spacing * 2
        leftPadding: control.indicator.width + control.spacing
    }
}