import QtQuick 2.0
import QtGraphicalEffects 1.0
import com.viavi.style 1.0

Rectangle {
    id: root

    property bool isApply: false
    property bool isClose: false
    property bool isDisabled: false
    property bool isMenu: false
    property bool isRepeatable: true
    property real alpha: 1
    property real alphaPressed: 1
    property alias bold: label.font.bold
    property color bgColor: isMenu ? "#500778" : "#FFFFFF"
    property color bgColorDisabled: bgColor
    property color bgColorPressed: isClose ? "#D50032" : isMenu ? "#00A9E0" : "#500778"
    property color fgColor: isApply ? "#00A9E0" : isMenu ? "#FFFFFF" : "#000000"
    property color fgColorDisabled: "#DBDBDB"
    property color fgColorPressed: "#FFFFFF"
    property string img: ""
    property string imgPressed: img
    property alias text: label.text
    property alias textSize: label.font.pixelSize
    signal clicked()
    width: 50
    height: 50 * JobManagerStyle.keyboardHeightScale
    color: isDisabled ? bgColorDisabled : button.pressed ? bgColorPressed : bgColor
    opacity: button.pressed ? alphaPressed : alpha
    Text {
        id: label
        anchors.fill: parent
        font { bold: false; family: ViaviStyle.layout.fontFamily; pixelSize: 20 }
        fontSizeMode: Text.Fit
        minimumPixelSize: 0
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: parent.text
        color: isDisabled ? fgColorDisabled : button.pressed ? fgColorPressed : fgColor
        visible: parent.img === ""
    }
    Loader {
        active: root.visible ? !label.visible : false
        anchors.centerIn: parent

        sourceComponent: Image {
            source: button.pressed ? imgPressed : img
            sourceSize { width: root.width; height: root.height }
        }
    }
    MouseArea {
        id: button
        anchors.fill: parent
        enabled: !isDisabled
        onClicked: if(enabled) parent.clicked()
        onPressAndHold: if (isRepeatable) timer.start()
        onReleased: timer.stop()
    }
    Timer {
        id: timer; interval: 100; running: false; repeat: true
        onTriggered: if (!isDisabled) parent.clicked()
    }
    onVisibleChanged: timer.stop()
}
