import QtQuick 2.9
import QtQuick.Controls 2.2
import com.viavi.style 1.0
import com.viavi.jobmanager_ui 1.0

ProgressBar {
    id: root

    property Job job
    property bool showText: JobManager.currentJob === job

    height: showText ? completionLabel.implicitHeight : completionLabel.implicitHeight / 2

    opacity: (job && job.totalNumberOfRequiredTests > 0) ? 1.0 : 0.0

    value: {
        if(job && job.totalNumberOfRequiredTests >= 0)
        {
            return job.numberOfCompletedRequiredTests / job.totalNumberOfRequiredTests;
        }
        return 0;
    }

    background: Rectangle {
        id: backgroundRect
        anchors.fill: parent

        color: JobManagerStyle.progressBarBackground
    }

    contentItem: Item {
        Rectangle {
            id: contentRectangle
            
            width: root.visualPosition * parent.width
            height: parent.height
            color: JobManagerStyle.progressBarContent
        }
    }

    // If enought space in the completion bar, show the label on the left side.
    //Otherwise, show it on the right side.
    Label {
        id: completionLabel

        font: ViaviStyle.layout.mediumBoldFont

        property int marginSize: ViaviStyle.layout.mediumMargin
        property int availableSpace: contentRectangle.width
        property int requiredSpace: completionLabel.implicitWidth + marginSize

        anchors.verticalCenter: parent.verticalCenter
        anchors.leftMargin: marginSize
        anchors.rightMargin: marginSize

        width: Math.min(implicitWidth, backgroundRect.width - marginSize)

        visible: showText
        z: 1
        elide: Label.ElideRight

        text: {
            if(job)
            {
                return job.numberOfCompletedRequiredTests
                    + " " 
                    + qsTr("of")
                    + " "
                    + job.totalNumberOfRequiredTests;
            }
            return "";
        }

        states: [
            State {
                name: "text_on_left"
                when: completionLabel.requiredSpace <= completionLabel.availableSpace

                AnchorChanges {
                    target: completionLabel
                    anchors.left: parent.left
                }

                PropertyChanges {
                    target: completionLabel
                    color: JobManagerStyle.progressBarContentText
                }
            }, 

            State {
                name: "text_on_right"
                when: completionLabel.requiredSpace > completionLabel.availableSpace

                AnchorChanges {
                    target: completionLabel
                    anchors.right: parent.right
                }

                PropertyChanges {
                    target: completionLabel
                    color: JobManagerStyle.progressBarBackgroundText
                }
            }
        ]
    }
}