import QtQuick 2.9
import QtQuick.Controls 2.2
import QtQuick.Layouts 1.2
import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.jobmanager_ui 1.0

Rectangle {
    id: root

    // How long will the mssage be visible
    property int messageVisibleTimeMs: 3000

    // Shows the given message and dissapears after messageVisibleTimeMs
    function show(message)
    {
        toastMessageLabel.text = message;
        root.width = Qt.binding(function() { return toastMessageLabel.implicitWidth * 1.5 });

        hideMessageTimer.start();
    }

    color: ViaviColor.lightBlue
    radius: height / 2

    width: 0
    implicitHeight: toastMessageLabel.implicitHeight * 1.5
    visible: width > 0
    clip: true

    Behavior on width {
        PropertyAnimation {
            duration: 500
        }
    }

    Timer {
        id: hideMessageTimer

        running: false
        interval: messageVisibleTimeMs

        onTriggered: {
            root.width = 0;
        }
    }

    Label {
        id: toastMessageLabel

        anchors.centerIn: parent

        font: ViaviStyle.layout.largeBoldFont
    }
}