pragma Singleton

import QtQuick 2.9
import com.viavi.style 1.0

// Edits the ViavStyle properties and introduces new properties
Item {
    // The global configuration object
    property JobManagerConfig config: JobManagerConfig {}

    // Colors used by the Job Manager UI
    property color headerBackgroundColor: ViaviColor.viaviPurple
    property color headerForegroundColor: ViaviColor.white
    property color footerBackgroundColor: ViaviColor.viaviPurple
    property color footerForegroundColor: ViaviColor.white

    property color jobHeaderBackground: ViaviColor.lightGray2

    property color progressBarBackground: ViaviColor.white
    property color progressBarBackgroundText: ViaviColor.black
    property color progressBarContent: ViaviColor.viaviPurple
    property color progressBarContentText: ViaviColor.white

    // Test table
    property color testTableBackground: ViaviColor.white
    property color testTableHeaderBackground: ViaviColor.lightGray1
    property color testTableHeaderForeground: ViaviColor.darkGray
    property font testTypeFont: ViaviStyle.layout.mediumFont
    property font testPropertyFont: ViaviStyle.layout.mediumFont
    property font testStatusFont: ViaviStyle.layout.mediumBoldFont
    property font testHeaderFont: ViaviStyle.layout.mediumFont
    property size launchIconSize: Qt.size(30 * ViaviStyle.layout.scaleFactor, 30 * ViaviStyle.layout.scaleFactor)
    property size syncStatusIconSize: Qt.size(30 * ViaviStyle.layout.scaleFactor, 30 * ViaviStyle.layout.scaleFactor)
    property size moreTestOptionsIconSize: Qt.size(30 * ViaviStyle.layout.scaleFactor, 30 * ViaviStyle.layout.scaleFactor)
    property int testRowMargins: 0

    // Text Edit
    property color textEditBackgroundColor: ViaviColor.white
    property color textEditBackgroundColorDisabled: ViaviColor.white
    property color textEditBorderColor: ViaviColor.black
    property color textEditBorderColorFocused: ViaviColor.viaviLightPurple
    property color textEditDisabledColor: ViaviColor.darkGray

    // Scroll bar
    property color scrollBarColor: ViaviColor.viaviPurple
    property int scrollBarWidth: 15 * ViaviStyle.layout.scaleFactor

    //// These properties control the radius and border for IJM cards
    property int cardCornerRadius: 0
    property int cardBorderWidth: 0

    // Keyboard 
    property real keyboardHeightScale: 1.0

    // Changes to the global ViaviTheme object used for the 
    //reusable components
    ViaviTheme {
        id: jobManagerTheme

        // General
        background: ViaviColor.lightGray1
        border: ViaviColor.transparent
        
        // Clickable items
        clickableBackground: ViaviColor.lightGray3
        clickableForeground: foreground
        clickableBackgroundPressed: ViaviColor.viaviPurple
        clickableForegroundPressed: clickableForeground

        // Highlighted clickable items
        highlightedBackground: ViaviColor.lightBlue
        highlightedForeground: ViaviColor.black
    }

    ViaviLayout {
        id: jobManagerLayout

        scaleFactor: config ? config.scaleFactor : 1.0
    }

    Component.onCompleted: {
        console.log("Initializing JobManagerStyle");
        ViaviStyle.theme = jobManagerTheme;
        ViaviStyle.layout = jobManagerLayout;
    }
}
