import QtQuick 2.9
import QtQuick.Controls 2.2
import com.viavi.style 1.0

Popup 
{
    id: root

    // Holds the item currently being edited
    property Item editedItem: null

    // Open the keyboard to edit the given textItem. A text item
    //is a qml item with a "text" field.
    function openKeyboardForTextItem(textItem)
    {
        close();

        root.visible = true;
        root.editedItem = textItem;
        rtsKeyboard.openDirectEdit(textItem);
    }

    // Open the keyboard to edit the given textItem, allowing only 
    //numeric input.
    function openNumericKeyboardForTextItem(textItem)
    {
        close();

        root.visible = true;
        root.editedItem = textItem;
        rtsNumericKeyboard.openDirectEdit(textItem);
    }

    // Closes the keyboard
    function close()
    {
        realKeyboardClosed();
        rtsKeyboard.close();
        rtsNumericKeyboard.close();
    }

    onAboutToHide: {
        // If we close the keyboard by clicking outside, unfocus the edited item
        if(editedItem)
        {
            editedItem.focus = false;
        }
    }


    visible: false
    
    spacing: 0
    margins: 0
    padding: 0

    width: parent.width
    height: {
        if(!visible)
        {
            return 0;
        }
        
        if(rtsNumericKeyboard.visible)
        {
            return rtsNumericKeyboard.height;
        }
        return rtsKeyboard.height;
    }

    z: 2

    background: Rectangle {
        color: "transparent"
    }

    // Internal
    function realKeyboardClosed()
    {
        root.editedItem = null;
        root.visible = false;
    }

    RTSKeyboard {
        id: rtsKeyboard

        width: parent.width
        visible: false

        onSigClosed: {
            realKeyboardClosed();
        }

        onSigEntered: {
            realKeyboardClosed();
        }

        onVisibleChanged: {
            if(visible === false)
            {
                realKeyboardClosed();
            }
        }
    }

    RTSNumericKeyboard {
        id: rtsNumericKeyboard

        width: parent.width
        visible: false

        onSigCanceled: {
            realKeyboardClosed();
        }

        onSigEntered: {
            realKeyboardClosed();
        }

        onVisibleChanged: {
            if(visible === false)
            {
                realKeyboardClosed();
            }
        }
    }
}