import QtQuick 2.9

Item {
    // Scale factor
    property real scaleFactor: 1.0

    // Window size
    property int windowWidth: 500
    property int windowHeight: 500

    // Job property configs
    property var jobPropertyList: []
    property var jobPropertyDisplayNames: defaultJobPropertyDisplayNames
    readonly property var defaultJobPropertyDisplayNames: ({
        "customerName": qsTr("Customer Name"), 
        "techId": qsTr("Tech ID"),
        "typeName": qsTr("Template Name"),
        "contractorId": qsTr("Contractor Id")
    })

    // Test property configs
    property var testPropertyDisplayNames: defaultTestPropertyDisplayNames
    property var defaultTestPropertyDisplayNames: ({
        "configuration": qsTr("Configuration"), 
        "location": qsTr("Location")
    })
    property var preferredTestProperties: ["location", "configuration"]
    property int preferredTestPropertiesAlwaysVisible: 2

    // Locations to be used for the file dialog
    property var fileDialogFolders: ({})

    // Until these dialogs are implemented, solutions have to provide implementation
    signal createReportClicked(var job);
    signal openGuideClicked(var job, var test);
    signal selectLogoClicked(var job);

    // Signal called before a test is launched
    signal testAboutToLaunch(var test);

    // Signal called to open the delete dialog
    signal deleteJob(var job);

    // Signal called to open the "..." menu
    signal openMoreOptionsMenu(var job, var test, var referenceItem);

    //Set this to true when the feature gets implemented
    property bool showTestSyncIcon: false
    
    // Provide choice to hide away moreOptions "three dots" column
    property bool showMoreOptions: true
}
