import QtQuick 2.9
import QtQuick.Controls 2.2
import QtQuick.Layouts 1.2
import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.jobmanager_ui 1.0

Rectangle {
    id: root

    property Job job
    property bool allowEditing: job && !job.isArchived
    property var jobPropertyList: {
        if(JobManagerStyle.config.jobPropertyList.length !== 0)
        {
            return JobManagerStyle.config.jobPropertyList
        }

        if(job)
        {
            return job.allDisplayableJobProperties;
        }

        return [];
    }
    property var jobPropertyDisplayNames: JobManagerStyle.config.jobPropertyDisplayNames
    
    height: column.height + ViaviStyle.layout.mediumMargin
    color: JobManagerStyle.testTableBackground
    radius: JobManagerStyle.cardCornerRadius
    border.color: ViaviColor.black
    border.width: JobManagerStyle.cardBorderWidth

    Column {
        id: column

        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layout.mediumMargin
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layout.mediumMargin

        Label {
            id: titleLabel

            width: parent.width
            horizontalAlignment: Label.AlignHCenter

            font: ViaviStyle.layout.largeBoldFont
            text: qsTr("Job Information")
        }

        RowLayout {
            id: rowLayout

            spacing: ViaviStyle.layout.mediumMargin

            width: parent.width

            ColumnLayout {

                TextField {
                    id: dummyTF
                    visible: false
                }

                Layout.alignment: Qt.AlignLeft | Qt.AlignTop
                Layout.preferredHeight: childrenRect.height

                Repeater {
                    model: root.jobPropertyList

                    Label {
                        text: {
                            if(modelData in root.jobPropertyDisplayNames)
                                return root.jobPropertyDisplayNames[modelData];
                            if(modelData in job.jobPropertyDisplayInfos)
                            {
                                if(job.jobPropertyDisplayInfos[modelData].label.length !== 0)
                                {
                                    return job.jobPropertyDisplayInfos[modelData].label;
                                }
                            }
                            return modelData;
                        }

                        Layout.preferredHeight: dummyTF.implicitHeight

                        verticalAlignment: Label.AlignVCenter
                    }
                }
            }

            ColumnLayout {
                id: valueEdits

                Layout.preferredHeight: childrenRect.height
                Layout.fillWidth: true

                Repeater {
                    model: root.jobPropertyList

                    JobPropertyField {
                        Layout.fillWidth: true
                        allowEditing: root.allowEditing
                        job: root.job
                        propName: modelData
                    }
                }
            }
        }
    }
}