import QtQuick 2.9
import QtQuick.Controls 2.2
import QtQuick.Layouts 1.2
import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.jobmanager_ui 1.0

Page {
    id: root

    property Job job

    title: qsTr("Job Details")

    onJobChanged: {
        if(!job)
        {
            console.log("Job was deleted. Closing the Details page");
            stackView.pop();
        }
    }

    background: Rectangle {
        anchors.fill: parent
        color: ViaviStyle.theme.background
    }

    Flickable {
        id: flickable
        anchors.fill: parent
        anchors.bottomMargin: ViaviStyle.layout.mediumMargin

        ScrollBar.vertical: JobManagerScrollBar { id: scrollBar }

        flickableDirection: Flickable.VerticalFlick
        contentHeight: contentItem.implicitHeight
        contentWidth: width - Math.max(scrollBar.width - ViaviStyle.layout.mediumMargin, 0)


        ColumnLayout {
            id: contentItem

            anchors.top: parent.top
            anchors.topMargin: ViaviStyle.layout.smallMargin

            anchors.left: parent.left
            anchors.leftMargin: ViaviStyle.layout.mediumMargin

            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layout.mediumMargin

            spacing: ViaviStyle.layout.mediumMargin

            JobHeader {
                id: jobHeader
                Layout.fillWidth: true
                Layout.preferredHeight: height

                job: root.job
                showProgressBarText: true
                showDetailsButton: false
                showCompleteButton: true
                showCreateReportButton: true

                height: childrenRect.height + ViaviStyle.layout.largeMargin
                radius: JobManagerStyle.cardCornerRadius / 2
                border.width: JobManagerStyle.cardBorderWidth / 2

                DefaultLayoutJobInformation {
                    id: jobInformation

                    anchors.top: parent.top
                    anchors.topMargin: jobHeader.headerGridHeight + ViaviStyle.layout.mediumMargin
                    anchors.horizontalCenter: parent.horizontalCenter
                    width: parent.width * 0.98

                    job: root.job
                }
            }
        }
    }
}
