import QtQuick 2.9
import QtQuick.Controls 2.2
import QtQuick.Layouts 1.2
import com.viavi.style 1.0
import com.viavi.style.components 1.0
import com.viavi.jobmanager_ui 1.0

Page {
    id: root

    title: qsTr("Archived Jobs")

    background: Rectangle {
        anchors.fill: parent
        color: ViaviStyle.theme.background
    }

    Flickable {
        id: flickable

        anchors.fill: parent
        anchors.bottomMargin: ViaviStyle.layout.mediumMargin

        ScrollBar.vertical: JobManagerScrollBar { id: scrollBar }

        flickableDirection: Flickable.VerticalFlick
        contentHeight: column.implicitHeight
        contentWidth: width - Math.max(scrollBar.width - ViaviStyle.layout.mediumMargin, 0)

        ColumnLayout {
            id: column

            anchors.top: parent.top
            anchors.topMargin: ViaviStyle.layout.smallMargin
            anchors.left: parent.left
            anchors.leftMargin: ViaviStyle.layout.mediumMargin
            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layout.mediumMargin

            spacing: ViaviStyle.layout.smallMargin


            ListView {
                id: jobList

                Layout.preferredWidth: parent.width
                Layout.preferredHeight: childrenRect.height

                interactive: false
                spacing: column.spacing
                visible: count > 0

                model: JobManager.archivedJobs

                delegate: JobHeader {
                    job: model.job
                    border.width: JobManagerStyle.cardBorderWidth / 2
                    radius: JobManagerStyle.cardCornerRadius / 2
                    onDetailsClicked: {
                        openJobDetailsPage(job);
                    }
                }
            }

            Label {
                Layout.preferredWidth: parent.width
                Layout.preferredHeight: flickable.height

                visible: !jobList.visible

                verticalAlignment: Label.AlignVCenter
                horizontalAlignment: Label.AlignHCenter

                font: ViaviStyle.layout.largeFont
                text: qsTr("No archived jobs")
            }
        }
    }

    function openJobDetailsPage(job)
    {
        stackView.push("DefaultLayoutDetailsPage.qml", { "job": job });
    }
}
