import ctypes
import struct

# constant for linux portability
_IOC_NRBITS = 8
_IOC_TYPEBITS = 8

# architecture specific
_IOC_SIZEBITS = 14
_IOC_DIRBITS = 2

_IOC_NRMASK = (1 << _IOC_NRBITS) - 1
_IOC_TYPEMASK = (1 << _IOC_TYPEBITS) - 1
_IOC_SIZEMASK = (1 << _IOC_SIZEBITS) - 1
_IOC_DIRMASK = (1 << _IOC_DIRBITS) - 1

_IOC_NRSHIFT = 0
_IOC_TYPESHIFT = _IOC_NRSHIFT + _IOC_NRBITS
_IOC_SIZESHIFT = _IOC_TYPESHIFT + _IOC_TYPEBITS
_IOC_DIRSHIFT = _IOC_SIZESHIFT + _IOC_SIZEBITS

_IOC_NONE = 0
_IOC_WRITE = 1
_IOC_READ = 2


def IOC(dir, type, nr, size):
    if isinstance(size, str):
        size = struct.calcsize(size)
    return dir << _IOC_DIRSHIFT | \
        type << _IOC_TYPESHIFT | \
        nr << _IOC_NRSHIFT | \
        size << _IOC_SIZESHIFT


def IO(type, nr):
    return IOC(_IOC_NONE, type, nr, 0)


def IOR(type, nr, size):
    return IOC(_IOC_READ, type, nr, size)


def IOW(type, nr, size):
    return IOC(_IOC_WRITE, type, nr, size)


def IOWR(type, nr, size):
    return IOC(_IOC_READ | _IOC_WRITE, type, nr, size)

def letoh32(v):
    return struct.unpack("=I", struct.pack(">I", v))[0]

def htole32(v):
    return struct.unpack(">I", struct.pack("=I", v))[0]

def letoh16(v):
    return struct.unpack("=H", struct.pack(">H", v))[0]

def htole16(v):
    return struct.unpack(">H", struct.pack("=H", v))[0]
