from paste.translogger import TransLogger
import logging

filter_urls = {
    '/api/v1/jobs/changecount',
    '/api/jobs/v2/changecount'
}
class ViaviPasteTransLogger(TransLogger):
    def __init__(self, application,
                 logger=None,
                 format=None,
                 logging_level=logging.INFO,
                 logger_name='wsgi',
                 setup_console_handler=False,
                 set_logger_level=logging.INFO):
        TransLogger.__init__(self, application, logger, format, logging_level, logger_name, setup_console_handler, set_logger_level)
        try:
            #Disable the debug logging from paste's threadpool
            logging.getLogger('paste.httpserver.ThreadPool').setLevel(logging.ERROR)
        except:
            pass


    def write_log(self, environ, method, req_uri, start, status, bytes):  
        #print("ViaviPasteTransLogger:", req_uri)
        if not req_uri in filter_urls:
            TransLogger.write_log(self, environ, method, req_uri, start, status, bytes)  