#Utilities for marshmallow 2 to 3 compatibility 
import marshmallow

MARSHMALLOW_VERSION_INFO = tuple([int(part) for part in marshmallow.__version__.split(".") if part.isdigit()])
MARSHMALLOW__MAJOR_VERSION = MARSHMALLOW_VERSION_INFO[0] 
#In Marshmallow 2 the loads and dumps methods returns a MarshalResult. 
# For Marshmallow 3 these methods just return strings  
#https://marshmallow.readthedocs.io/en/stable/upgrading.html#schemas-are-always-strict
#This method converts the Marshmallow 2 result to Marshmallow string result.
def marshmallow_data_compat(marshmallow_data):
    #print("MARSHMALLOW_VERSION_INFO: ", MARSHMALLOW_VERSION_INFO)
    if MARSHMALLOW__MAJOR_VERSION >= 3:
        rv = marshmallow_data
    else:
        if type(marshmallow_data) is marshmallow.schema.MarshalResult or type(marshmallow_data) is marshmallow.schema.UnmarshalResult:
            rv = marshmallow_data.data 
            if marshmallow_data.errors:                
                print("marshmallow_data_compat error: ", marshmallow_data.errors)
                #Raise an exception like marshmallow 3 when a field is missing
                # raise marshmallow.exceptions.ValidationError(marshmallow_data.errors)
                return None
    return rv

#In Marshmallow 2 unknown fields are allowed by default
#In Marshmallow 3 it must be explicitiy stated that we want to allow unkown fields
def marshmallow_unknown_arg():
    arg = {}
    try: 
        from marshmallow.utils import INCLUDE
        arg = {"unknown" : "INCLUDE"}
    except:
        pass
    return arg
