"""Module defining the VNC namedtuple
YAML below is used to generate swagger
---
username:
    type: string
    description: >-
        optional username to use to authenticate with the
        VNC server
    x-nullable: true
password:
    type: string
    description: >-
        optional password to use to authenticate with the
        VNC server
    x-nullable: true
port:
    type: number
    description: >-
        optional port number the VNC server is listening on
        for WebSocket connections, defaults to 5900
errorMessage:
    type: string
    description: a user readable error message that can be displayed
"""
import collections

VNC = collections.namedtuple(
    'vnc',
    field_names=[
        'username',
        'password',
        'port',
        'errorMessage',
    ]
)
