'''Module that syncs/registers jobmanager reports to/with stratasync
'''
import os
import sys
import logging
import time

from rest_api.products.usc import dbus
from rest_api.products.usc import get_dbus_bus

log = logging.getLogger(__name__)


USC_SERVICE = "com.jdsu.usc" # starting point for getting Services list (makes this platform independent - com.jdsu.isu / com.jdsu.bert, etc.)
USC_PATH = "/Usc"

PDF_FILES = "*.pdf" # This may need to be platform-dependent, or specify a little more than just 'TESTDATA'
JOB_FILES = "*.job.json" 
 
# 
JOB_MANAGER_SERVICE_NAME = "com.viavisolutions.jobmanager"

FILE_TYPE_NAME_PDF_TESTDATA = "TESTDATA.PDF REPORT"
FILE_TYPE_NAME_PROCEDURES = "CONFIG.Test Procedures" #TBC


def register_report_path(file_path):
    """
    Function to sync jobmanager reports with stratasync
    """
    proxy_object = get_usc_proxy_object()
    if proxy_object:
        register_service(proxy_object)
        register_path(proxy_object, file_path, PDF_FILES, FILE_TYPE_NAME_PDF_TESTDATA)


def register_procedures_path(file_path):
    """Function to sync job manager test procedures with stratasync
    """
    proxy_object = get_usc_proxy_object()
    if proxy_object:
        register_path(proxy_object, file_path, PDF_FILES, FILE_TYPE_NAME_PROCEDURES)

def get_usc_proxy_object():
    """
    Gets the Usc proxy object to interact with remote Usc
    """
    proxy_object = None
    if not dbus:
        return None
    try:        
        sys_bus = get_dbus_bus()
        proxy_object = sys_bus.get_object(USC_SERVICE, USC_PATH)
    except dbus.DBusException:
        log.warning(sys.exc_info())

    return proxy_object

def register_service(proxy):
    """
    Registers jobmanager service with Usc
    """
    attempt = 0
    while attempt < 3:
        try:
            proxy.Register(JOB_MANAGER_SERVICE_NAME)
            break
        except dbus.exceptions.DBusException:
            log.warning('Register USC failed, trying again.')
            attempt += 1
            time.sleep(1)

def register_path(proxy, path, file_name, file_type):
    """
    Registers the rooth path for the reports and the files(reports) to sync
    """
    if not os.path.exists(path):
        os.makedirs(path)
    attempt = 0
    while attempt < 3:
        try:
            proxy.Register_Root_Path(path)
            proxy.RegisterFileToSync(path, file_name, file_type, True)
            break
        except dbus.exceptions.DBusException:
            log.warning('Registering file path %s with USC failed, trying again.', path)
            attempt += 1
            time.sleep(1)
