'''Module that syncs path for incoming CDM files
'''
import os

from .file_sync import get_usc_proxy_object

USC_SERVICE = "com.jdsu.usc"
USC_PATH = "/Usc"

CDM_DOWNSTREAM_FILEPATH = '/tmp/cdm/'
CDM_DOWNSTREAM_TEMPLATES_PATH = '/tmp/workflow/' #  **already provided to USC by ISU but also needed here**
JOB_FILE_EXT = '*.job.json'
FILE_TYPE_NAME_JOB_INSTANCE = "JOB.Info"
TEMPLATE_FILE_EXT = '*.tpl.json'
CDM_FILE_EXT = '*.cdm.json'
FILE_TYPE_MANUAL_STEP = 'TESTDATA.JSON.MANUAL.STEP'
FILE_TYPE_NAME_JOB_TEMPLATES = "TEMPLATE.Job Template"

def register_cdm_filepath(jobs_dir):
    """
    Registers the directory for incoming files from Stratasync

    """
    proxy_object = get_usc_proxy_object()
    if proxy_object:
        if not os.path.exists(CDM_DOWNSTREAM_FILEPATH):
            os.makedirs(CDM_DOWNSTREAM_FILEPATH)
        proxy_object.Register_Root_Path(CDM_DOWNSTREAM_FILEPATH)

        if not os.path.exists(CDM_DOWNSTREAM_TEMPLATES_PATH):
            os.makedirs(CDM_DOWNSTREAM_TEMPLATES_PATH)
        proxy_object.Register_Root_Path(CDM_DOWNSTREAM_TEMPLATES_PATH)

        northbound_jobs_cdm_dir = os.path.join(jobs_dir, "northbound_jobs/")
        if not os.path.exists(northbound_jobs_cdm_dir):
            os.makedirs(northbound_jobs_cdm_dir)
        proxy_object.Register_Root_Path(northbound_jobs_cdm_dir)
        proxy_object.RegisterFileToSync(northbound_jobs_cdm_dir, JOB_FILE_EXT, FILE_TYPE_NAME_JOB_INSTANCE, True)
        proxy_object.RegisterFileToSync(northbound_jobs_cdm_dir, TEMPLATE_FILE_EXT, FILE_TYPE_NAME_JOB_TEMPLATES, True)

        northbound_cdm_data_dir = os.path.join(jobs_dir, "northbound_cdm/")
        if not os.path.exists(northbound_cdm_data_dir):
            os.makedirs(northbound_cdm_data_dir)
        proxy_object.Register_Root_Path(northbound_cdm_data_dir)
        proxy_object.RegisterFileToSync(northbound_cdm_data_dir, CDM_FILE_EXT, FILE_TYPE_MANUAL_STEP, True)            


