"""Module for interoperating with the Universal Sync Client over the dbus interface
"""
import sys
import logging

log = logging.getLogger(__name__)

try:
    import dbus
except ImportError:
    log.warning(sys.exc_info())
    dbus = None

usc_dbus_type = "system"

def get_dbus_bus(): 
    if usc_dbus_type == "session":
        return dbus.SessionBus()
    else:
        return dbus.SystemBus()


def set_dbus_bus(type = "system"):    
    global usc_dbus_type
    usc_dbus_type = type

