# """Module to process workflow.json files and save each job to an individual
# file
# """
# import os
# import argparse
# import logging

# from rest_api.api.job_manager.cdm_schemas_viavi import make_cdm_schema # use our own schema

# JOB_MANAGER_DIR = '/user/disk/job-manager/'
# CDM_JOB_NAME = '/tmp/workflow.json'

# log = logging.getLogger(__name__)

# def main():
#     """Function to open the CDM job file from StrataSync and save individual
#     CDM files for each job it contains
#     """
#     args = parse_args()
#     with open(CDM_JOB_NAME) as workflow_file:
#         workflow_json_string = workflow_file.read()
#     if args.jobs_dir is not None:
#         parse_cdm_job(workflow_json_string, args.jobs_dir)
#     else:
#         parse_cdm_job(workflow_json_string, JOB_MANAGER_DIR)

# def parse_args():
#     parser = argparse.ArgumentParser()
#     parser.add_argument('--jobs_dir',
#                         required=False,
#                         help='path to the directory where job files are stored')
#     args, leftovers = parser.parse_known_args()
#     return args

# def parse_cdm_job(cdm_json, jobs_dir):
#     """Function to parse the contents of a CDM job from StrataSync and save
#     the individual job as seperate files

#     args:
#         cdm_json (str): the json contents of the CDM file
#     """
#     top_schema = make_cdm_schema()
#     cdm_job = top_schema().loads(cdm_json).data
#     for cdm in cdm_job['cdm']:
#         single_cdm = {'cdm_version': cdm_job['cdm_version'],
#                       'cdm': [cdm]}

#         workorder_id = cdm['workflow']['workorder_id']
#         file_path = os.path.join(jobs_dir, '{}.job.json'.format(workorder_id))
#         cdm_str = top_schema().dumps(single_cdm).data
#         save_job_file(file_path, cdm_str)

# def save_job_file(file_path, cdm_str):
#     """Function to save a json string in cdm format to a file

#     args:
#         file_path (str): the path of the file to create
#         cdm_str (str): the string with to save
#     """
#     with open(file_path, 'wb') as job_file:
#         job_file.write(cdm_str.encode("utf-8"))


# if __name__ == "__main__":
#     main()
