# #! /usr/bin/python3
# '''
# Fiber version called by MTS/T-BERD's ISU service when notified across Dbus by USC.
# (Poached & adapted from Germantown's solution for 5800v2)
# One TODO: clear the /tmp/cdm/ file once it has been converted.
# '''

# import shutil
# import os
# import logging
# import traceback
# import json

# from rest_api.api.job_manager.cdm_schemas_viavi import make_cdm_schema, apply_corrected_cdm_values_to_original_cdm
# from rest_api.products.mts_services.instrument_jobs import notify_job_received, get_job_dir, get_job_extension, get_template_extension
# from rest_api.api.workflow import load_Mta_cdm_job




# CDM_JOB_NAME = '/tmp/cdm/workflow.cdm.json'

# log = logging.getLogger(__name__)

# def main():
#     """Function to open the CDM workflow file sent from StrataSync 
#     and save individual CDM files for each job it contains
#     """
#     with open(CDM_JOB_NAME) as workflow_file:
#         workflow_json_string = workflow_file.read()
#     parse_cdm_job(workflow_json_string)
#    workordersList = []
#    parse_cdm_job_tolerant( workflow_json_string, workordersList )

# def parse_cdm_job(cdm_json):
#     """Function to parse the contents of a CDM workflow file from StrataSync
#     and save individual jobs as separate files

#     args:
#         cdm_json (str): the json contents of the CDM file
#     """
#     try:
#         top_schema = make_cdm_schema()
#         cdm_job = top_schema().loads(cdm_json).data

#         for cdm in cdm_job['cdm']:
#             single_cdm = {'cdm_version': cdm_job['cdm_version'],
#                           'cdm': [cdm]}

#             workorder_id = cdm['workflow']['workorder_id']
#             file_path = ('{}{}' + get_job_extension()).format(get_job_dir(), workorder_id)
#             cdm_str = top_schema().dumps(single_cdm).data

#             save_job_file(file_path, cdm_str)
            
#             log.debug('parse_cdm_job: %s saved (Job Id %s)', file_path, workorder_id )
        
#         return True

#     except:
#         print(traceback.format_exc())
#         return False


# def parse_cdm_job_tolerant(cdm_json_param, listNewWorkorders):
#     """Function to parse the contents of a CDM workflow file from MTA
#     and save individual jobs as separate files

#     args:
#         cdm_json (str): the json contents of the CDM file
#     """
#     try:
#         top_schema = make_cdm_schema()

#         job_schema = top_schema().loads(cdm_json_param).data
#         job_corrected = top_schema().dump(job_schema).data
#         job_original = json.loads(cdm_json_param)

#         try:
#             for cdm_original, cdm_corrected in zip(job_original['cdm'], job_corrected['cdm']):
#                 key_list = set(cdm_original).union(set(cdm_corrected))

#                 try:
#                     for original_key in key_list:
#                         apply_corrected_cdm_values_to_original_cdm(original_key, cdm_original, cdm_corrected)
#                 except:
#                     print(traceback.format_exc())
#         except:
#             print(traceback.format_exc())

#         for cdm in job_original['cdm']:
#             single_cdm = {'cdmVersion': job_original['cdmVersion'],
#                           'cdm': [cdm]}

#             workorder_id = cdm['workflow']['workOrderId']
#             file_path = ('{}{}' + get_job_extension()).format(get_job_dir(), workorder_id)
#             cdm_str = json.dumps(single_cdm)

#             save_job_file(file_path, cdm_str)
            
#             # Memorise the new added file
#             if (listNewWorkorders != None):
#                 listNewWorkorders.append(file_path)
            
#             log.debug('parse_cdm_job: %s saved (Job Id %s)', file_path, workorder_id )
        
#         return True

#     except:
#         print(traceback.format_exc())
#         return False

# def parse_mta_cdm_job(cdm_json):
#     """Function to parse the contents of a CDM workflow file from StrataSync
#     and save individual jobs as separate files

#     args:
#         cdm_json (str): the json contents of the CDM file
#     """
#     try:

#         job_dir = get_job_dir()

#         # Create of a list of existing valid files before the addition of new files
#         listExistingWorkorders = []
        
#         for filename in os.listdir(job_dir):
#             file_path = os.path.join(job_dir, filename)
#             cdm_job = load_Mta_cdm_job(file_path)
#             if (cdm_job != None):
#                 listExistingWorkorders.append(file_path)

#         listNewWorkorders = []

#         bParseCdmJob0K = parse_cdm_job_tolerant(cdm_json, listNewWorkorders)

#         if (bParseCdmJob0K == True):

#             # And now the old workorders files absent from the list of new workorders are deleted
#             for old_file in listExistingWorkorders:
#                 if old_file not in listNewWorkorders:
#                     try:
#                         os.remove(old_file)
#                     except:
#                         pass


            
#         return bParseCdmJob0K

#     except:
#         print(traceback.format_exc())
#         return False


# def save_job_file(file_path, cdm_str):
#     """Function to save a json string (in cdm format) to a file

#     args:
#         file_path (str): the path of the file to create
#         cdm_str (str): the content to save
#     """
#     with open(file_path, 'wb') as job_file:
#         job_file.write(cdm_str.encode("utf-8"))




# if __name__ == "__main__":
#     main()




