"""Module containing code to connect an intrument to the vnc server
The main function is start_vnc, which returns an VNC namedtupple
"""
import subprocess

from rest_api.products.vnc import VNC

VNC_FILE_PASSWORD = "/tmp/vnc.passwd"
VNC_CMD = "/usr/bin/vmt_startvnc.sh"

def start_vnc(servername):
    """Function to send a request to vnc server manager to
       establish a connection to the vnc server.

    args:
        servername: hostname/address of clientmgr (usually '127.0.0.1')
    returns:
        named tuple:
            usename: optional username
            password: optional password
            port: VNC port #, defaults to 5900
            errorMessage: error message
    """

    result = subprocess.run(VNC_CMD, universal_newlines=True, stdout=subprocess.PIPE, shell=True)

    if result.returncode == 0:
        vnc = VNC(
            username='',
            password=result.stdout.rstrip('\n'),
            port=5900,
            errorMessage=''
            )
    else:
        vnc = VNC(
            username='',
            password='',
            port=0,
            errorMessage='VNC failed'
            )

    return vnc
