"""
Module handles sending time update info to
appropriate service to update the system time
"""

import os
from rest_api.products.pointsolution_services import get_pydbus_bus
import pytz
import logging
import json

log = logging.getLogger(__name__)

def update_local_time(time_value, location):
    """
    Sends a message to the instrument time service to update the local time

    Args:
        time_value {[DateTime]} -- [IEEE 8601 formatted datetime object]
        location (string): A string representation of the timezone (not used so far)
    Returns:
        True if the request was ack'd
    """
    DBusObjectName = 'com.viavisolutions.platform.SettingsConfiguration'
    DBusObjectPath = '/com/viavisolutions/platform/SettingsConfiguration'

    try:
        bus = get_pydbus_bus()
        proxy = bus.get(DBusObjectName, DBusObjectPath)
        success = proxy.SetSetting('DateTime', json.dumps({'datetime':time_value.isoformat()}))
    except:
        log.debug('## update_local_time(): Failed dbus call to S&C Service')
        return False

    if not success:
        log.debug('## update_local_time(): Failed to set datetime')

    return success

def update_utc_time(time_value):
    """
    Sends a message to the instrument time service to update the
    system utc time

    Args:
        time_value {[DateTime]} -- [IEEE 8601 formatted datetime object]

    Returns:
        True if the request was ack'd
    """
    utc_time = utc_from_local_time(time_value)
    return True

def utc_from_local_time(time_value):
    """

    Arguments:
        time_value {[DateTime]} -- [IEEE 8601 formatted datetime object]

    Returns:
        time string converted to utc
    """
    return time_value.astimezone(pytz.utc).isoformat()
