"""
Module handles sending location info to
appropriate service to update the instrument
location
"""

from rest_api.products.pointsolution_services import get_pydbus_bus
import json
import decimal
import logging

log = logging.getLogger(__name__)

def update_location(geolocation):
    """
    Sends a message to the instrument location service to update the location

    Returns:
        True if the request was ack'd
    """
    DBusObjectName = 'com.viavisolutions.platform.SettingsConfiguration'
    DBusObjectPath = '/com/viavisolutions/platform/SettingsConfiguration'
    success = True

    class DecimalEncoder(json.JSONEncoder):
        def default(self, o):
            if isinstance(o, decimal.Decimal):
                return float(o)
            return super(DecimalEncoder, self).default(o)

    try:
        bus = get_pydbus_bus()
        proxy = bus.get(DBusObjectName, DBusObjectPath)
        (exists, persisted, ss_config) = proxy.GetGroupProperties('Location')
        if not exists:
            success = proxy.AddGroup('Location', True, False)
            if not success:
                log.debug('## update_location(): Failed to add location settings group')
                return False

        settings_json = json.dumps(geolocation, cls=DecimalEncoder)
        success = proxy.SetSettingsByGroup('Location', settings_json)
        if not success:
            log.debug('## update_location(): Failed to set location settings')
            return False
    except:
        log.debug('## update_location(): Failed dbus call to S&C Service')
        return False
    return True
